% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminate.R
\name{terminatePAC}
\alias{terminatePAC}
\title{Terminates if relative deviation from estimated PAC bound for optimum is small. Works at 0.}
\usage{
terminatePAC(solution, lF)
}
\arguments{
\item{solution}{A named list with at least the following elements:
$name, $fitness, $value, $numberOfSolutions, 
$genotype, $phenotype, $phenotypeValue.}

\item{lF}{Local function configuration. It must contain
\itemize{
\item \code{lF$PACopt()} which returns 
      an estimation of an upper PAC bound 
      \code{ub} for the global optimum \code{g}
      with \code{P(ub<g)<lF$PACdelta()}.
\item \code{lF$TerminationEps()} which specifies the 
      the fraction of the global optimum
      used for computing the upper and lower bounds
      for the interval in which the best current 
      solution must be for terminating the algorithm. 
}}
}
\value{
Boolean.
}
\description{
\code{terminatePAC()} 
returns \code{TRUE} if the value of the current solution 
is in the interval from (PACopt - (PACopt*eps)) to 
(PACopt + (PACopt*eps)). If PACopt is zero, 
test interval (0-eps) to (0+eps).
}
\details{
By an idea of M. Talagrand we estimate \code{lF$PACopt()} 
         from the mean \code{m} and the standard deviation \code{s} of the population fitness 
         of the first population of the genetic algorithm we compute
         \code{m+s*qnorm(lF$PACdelta(), lower.tail=FALSE)} when the function we optimize 
         is in Hilbert space. For other spaces, this has to be adapted.
}
\examples{
    parm<-function(x){function() {return(x)}}
    lF<-list(); lF$PACopt<-parm(10.0); lF$TerminationEps<-parm(1.2);lF$Max<-parm(1.0)
    solution<-list(); solution$genotype<-list();  solution$genotype$fit<-0.5
    terminatePAC(solution, lF)
    solution<-list(); solution$genotype<-list();  solution$genotype$fit<-9.6
    terminatePAC(solution, lF)
}
\seealso{
Other Termination Condition: 
\code{\link{terminateAbsoluteError}()},
\code{\link{terminateGEQ}()},
\code{\link{terminateLEQ}()},
\code{\link{terminateRelativeError}()},
\code{\link{terminateRelativeErrorZero}()},
\code{\link{terminatedFalse}()}
}
\concept{Termination Condition}
