% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVectorAbundance.R
\name{plotVectorAbundance}
\alias{plotVectorAbundance}
\title{Plot Vector Abundance Over Time with Comparison to Historical Averages}
\usage{
plotVectorAbundance(
  token,
  interval,
  target_year,
  start_year = NULL,
  end_year = NULL,
  species,
  trap,
  agency_ids = NULL,
  sex = "female",
  trapnight_min = 1,
  trapnight_max = NULL
)
}
\arguments{
\item{token}{Authentication token for API access, typically obtained from `getToken()`}

\item{interval}{Time interval for aggregation. One of: "CollectionDate", "Week", "Biweek", "Month"}

\item{target_year}{The focal year to highlight in the plot}

\item{start_year}{Starting year for data retrieval. If NULL, defaults to 5 years before target_year}

\item{end_year}{Ending year for data retrieval (integer). If NULL, defaults to target_year}

\item{species}{Character vector for filtering species. View species in your data `unique(data$species_display_name)`. Defaults to all species if no selection}

\item{trap}{Character vector for filtering trap type by acronym. View trap types in your data`unique(data$trap_acronym`. Defaults to all trap types}

\item{agency_ids}{Agency identifier to filter data if applicable}

\item{sex}{Character vector for filtering sex type. View sex options `unique(data$sex_type`). Defaults to "female".}

\item{trapnight_min}{Minimum number of trap nights to include (numeric). Defaults to 1}

\item{trapnight_max}{Maximum number of trap nights to include (numeric). If NULL, uses maximum available}
}
\value{
A ggplot object showing vector abundance over time, with the target year highlighted in red
and historical average shown in blue
}
\description{
This function creates a time series plot showing vector (mosquito) abundance over multiple years,
highlighting a target year in red and optionally showing a historical average line. The plot
helps visualize trends and anomalies in vector populations.
}
\examples{
\dontrun{
# Basic usage with default parameters
token <- getToken()
plot <- plotVectorAbundance(
  token = token,
  interval = "Week",
  target_year = 2024,
  species = "Cx pipiens",
  trap = "CO2"
)

# Compare multiple years with custom date range
plot <- plotVectorAbundance(
  token = token,
  interval = "Month",
  target_year = 2024,
  start_year = 2020,
  end_year = 2024,
  species = "Ae aegypti",
  trap = c("BG", "CDC"),
  sex = "female",
  trapnight_min = 3
)
}

}
