% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural_breaks.R
\name{format_break_results}
\alias{format_break_results}
\title{Format Structural Break Results}
\usage{
format_break_results(break_results, alpha = 0.05)
}
\arguments{
\item{break_results}{Result from test_structural_breaks.}

\item{alpha}{Significance level for interpretation. Default 0.05.}
}
\value{
A data frame with formatted test summaries.
}
\description{
Creates a formatted summary of structural break test results.
}
\examples{
\donttest{
if (requireNamespace("strucchange", quietly = TRUE)) {
  set.seed(123)
  years <- 1980:2020
  panel <- data.frame(
    year = rep(years, 5),
    sector = rep(LETTERS[1:5], each = length(years)),
    log_direct = rnorm(length(years) * 5, 5, 0.5),
    log_production = rnorm(length(years) * 5, 5, 0.5)
  )

  break_tests <- test_structural_breaks(panel)
  summary_df <- format_break_results(break_tests)
  print(summary_df)
}
}

}
