% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajmsm_gform.R
\name{trajmsm_gform}
\alias{trajmsm_gform}
\title{Parametric g-formula}
\usage{
trajmsm_gform(
  formula = formula,
  rep = 50,
  identifier,
  baseline,
  covariates,
  treatment,
  outcome,
  total_followup,
  time = time,
  time_values,
  var_cov,
  trajmodel,
  ref,
  obsdata
)
}
\arguments{
\item{formula}{Specification of the model for the outcome to be fitted.}

\item{rep}{Number of repetitions for the bootstrap.}

\item{identifier}{Name of the column of the unique identifier.}

\item{baseline}{Vector of names of the baseline covariates.}

\item{covariates}{List of names of the time-varying covariates.}

\item{treatment}{Vector of names of the time-varying treatment.}

\item{outcome}{Name of the outcome of interest.}

\item{total_followup}{Total length of follow-up.}

\item{time}{Name of the time variable.}

\item{time_values}{Measuring times.}

\item{var_cov}{Names of the time-varying covariates.}

\item{trajmodel}{Trajectory model built with the observed treatment.}

\item{ref}{The reference trajectory group.}

\item{obsdata}{Observed data in wide format.}
}
\value{
Provides a matrix of estimates for LCGA-MSM, obtained using the g-formula method.
}
\description{
Estimate parameters of LCGA-MSM using g-formula
 and bootstrap to get standard errors.
}
\examples{
\donttest{
obsdata_long = gendata(n = 1000, format = "long", total_followup = 6, seed = 845)
years <- 2011:2016
baseline_var <- c("age","sex")
variables <- c("hyper", "bmi")
var_cov <- c("statins","hyper", "bmi")
covariates <- lapply(years, function(year) {
paste0(variables, year)})
treatment_var <- paste0("statins", 2011:2016)
formula_treatment = as.formula(cbind(statins, 1 - statins) ~ time)
restraj = build_traj(obsdata = obsdata_long, number_traj = 3,
formula = formula_treatment, identifier = "id")
datapost = restraj$data_post
trajmsm_long <- merge(obsdata_long, datapost, by = "id")
    AggFormula <- as.formula(paste("statins", "~", "time", "+", "class"))
    AggTrajData <- aggregate(AggFormula, data = trajmsm_long, FUN = mean)
    AggTrajData
obsdata = reshape(data = trajmsm_long, direction = "wide", idvar = "id",
v.names = c("statins","bmi","hyper"), timevar = "time", sep ="")
formula = paste0("y ~", paste0(treatment_var,collapse = "+"), "+",
                paste0(unlist(covariates), collapse = "+"),"+",
                paste0(baseline_var, collapse = "+"))
resmsm_gform <- trajmsm_gform(formula = formula, identifier = "id",rep = 5,
baseline = baseline_var, covariates = covariates, var_cov = var_cov,
treatment = treatment_var, outcome = "y", total_followup = 6,time = "time",
time_values = years, trajmodel = restraj$traj_model,ref = "1", obsdata =   obsdata )
resmsm_gform
}
}
\author{
Awa Diop Denis Talbot
}
