% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-pieGrob.R
\name{pieGrob}
\alias{pieGrob}
\alias{grid.pieGrob}
\title{Create a pie grob}
\usage{
pieGrob(rads, fills = NULL, wts = NULL, name = NULL, vp = NULL, gp = NULL)

grid.pieGrob(rads, fills = NULL, wts = NULL, name = NULL, vp = NULL, gp = NULL)
}
\arguments{
\item{rads}{Numeric, radius values for each slice from 0 to 1}

\item{fills}{Colors to fill the slices}

\item{wts}{Numeric, the relative portion of each slice}

\item{name, vp, gp}{Passed to \link[grid:grid.grob]{grid::gTree}}
}
\value{
\code{pieGrob} \link[grid:grid.grob]{grid::grob} object
}
\description{
Create a pie grob
}
\details{
The default coloring can be set with \code{options("txp.fills")}.
}
\examples{
library(grid)

s <- seq(0.2, 1, by = 0.1)
grid.newpage()
grid.pieGrob(rads = s)
grid.newpage()
grid.pieGrob(rads = s, wts = s)

curr_txp_fills <- options()$txp.fills
options(txp.fills = 1:8)
grid.newpage()
grid.pieGrob(rads = s)
options(txp.fills = curr_txp_fills)

## Can edit
grid.newpage()
grid.pieGrob(rads = s, name = "myPie")
grid.ls() ## show the grid elements
grid.edit("myPie", fills = 1:9, wts = 9:1)

}
