% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-pieGridGrob.R
\name{pieGridGrob}
\alias{pieGridGrob}
\alias{grid.pieGridGrob}
\title{Make grid of pieGrobs}
\usage{
pieGridGrob(
  radMat,
  wts = NULL,
  fills = NULL,
  labels = NULL,
  showRadSum = FALSE,
  ncol = NULL,
  nrow = NULL,
  byrow = TRUE,
  name = NULL,
  gp = NULL,
  vp = NULL
)

grid.pieGridGrob(
  radMat,
  wts = NULL,
  fills = NULL,
  labels = NULL,
  showRadSum = FALSE,
  ncol = NULL,
  nrow = NULL,
  byrow = TRUE,
  name = NULL,
  gp = NULL,
  vp = NULL
)
}
\arguments{
\item{radMat}{\verb{matrix(<numeric>)}, observations by slice radii}

\item{wts}{\verb{vector(<numeric>)}, relative weights of each slice}

\item{fills}{Vector of colors to fill slices}

\item{labels}{\verb{vector(<character>)}, (optional) label for each observation}

\item{showRadSum}{Logical scalar, when \code{TRUE} show the weighted sum of slices
below the label}

\item{nrow, ncol}{Integer scalar, number of rows and columns for the grid}

\item{byrow}{Logical scalar, fill the grid by rows when \code{TRUE}}

\item{name, gp, vp}{Passed to \link[grid:grid.grob]{grid::gTree}}
}
\value{
\code{pieGrob} \link[grid:grid.grob]{grid::grob} object
}
\description{
Make grid of pieGrobs
}
\examples{
\donttest{
library(grid)

s <- seq(0.2, 1, by = 0.1)
smat <- do.call("rbind", replicate(20, s, simplify = FALSE))
grid.newpage()
grid.pieGridGrob(radMat = smat)

rownames(smat) <- sprintf("obs\%02d", 1:20)
grid.newpage()
grid.pieGridGrob(radMat = smat, wts = s)
grid.newpage()
grid.pieGridGrob(radMat = smat, wts = s, showRadSum = TRUE, labels = FALSE)
grid.newpage()
grid.pieGridGrob(radMat = smat, labels = "hello")
grid.newpage()
grid.pieGridGrob(radMat = smat, labels = 1:20)

## Can edit like normal grid objects
grid.newpage()
grid.pieGridGrob(radMat = smat, wts = s, showRadSum = TRUE)
grid.ls() ## shows grid elements
grid.edit("pie-20", fills = 1:9)
grid.edit("pie-19-label", gp = gpar(font = 2, col = "red"))
grid.edit("pie-1", wts = rep(1, 9), rads = rep(1, 9))
for (s in sprintf("pie-\%d-radSum", 2:4)) {
  grid.edit(s, gp = gpar(font = 2, col = "blue"))
}
}

}
