% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_ibs.R
\name{pairwise_ibs}
\alias{pairwise_ibs}
\title{Compute the Identity by State Matrix for a \code{gen_tibble} object}
\usage{
pairwise_ibs(
  x,
  as_matrix = FALSE,
  type = c("proportion", "adjusted_counts", "raw_counts"),
  block_size = bigstatsr::block_size(nrow(x))
)
}
\arguments{
\item{x}{a \code{gen_tibble} object.}

\item{as_matrix}{boolean, determining whether the results should be a square
symmetrical matrix (TRUE), or a tidied tibble (FALSE, the default)}

\item{type}{one of "proportion" (equivalent to "ibs" in PLINK),
"adjusted_counts" ("distance" in PLINK), and "raw_counts" (the counts of
identical alleles and non-missing alleles, from which the two other
quantities are computed)}

\item{block_size}{maximum number of loci read at once. More loci should
improve speed, but will tax memory.}
}
\value{
a \link[bigstatsr:FBM-class]{bigstatsr::FBM} of proportion or adjusted counts, or a list of
two \link[bigstatsr:FBM-class]{bigstatsr::FBM} matrices, one of counts of IBS by alleles, and one of
number of valid alleles (i.e. 2\emph{n_loci - 2}missing_loci)
}
\description{
This function computes the IBS matrix.
}
\details{
Note that monomorphic sites are currently considered. Remove monomorphic
sites before running pairwise_king if this is a concern.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

pairwise_ibs(example_gt, type = "proportion")

# Alternatively, return a matrix
pairwise_ibs(example_gt, type = "proportion", as_matrix = TRUE)

# Adjust block_size
pairwise_ibs(example_gt, block_size = 2)

# Change type
pairwise_ibs(example_gt, type = "adjusted_counts")
pairwise_ibs(example_gt, type = "raw_counts")
}
