% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{reframe_with_dct}
\alias{reframe_with_dct}
\title{Reframe with DCT}
\usage{
reframe_with_dct(
  .data,
  ...,
  .token_id_col = NULL,
  .by = NULL,
  .time_col = NULL,
  .order = 5
)
}
\arguments{
\item{.data}{A data frame}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant.}

\item{.token_id_col}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} The token ID column.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A grouping column.}

\item{.time_col}{A time column.}

\item{.order}{The number of DCT parameters to return. If \code{NA}, all DCT
parameters will be returned.}
}
\value{
A data frame with with the targeted DCT coefficients, along with two
additional columns

\describe{
\item{.param}{The nth DCT coefficient number}
\item{.n}{The number of original data values}
}
}
\description{
Reframe data columns using the Discrete Cosine Transform
}
\details{
This function will tidily apply the Discrete Cosine Transform with forward
normalization (see \link{dct} for more info) to the targeted columns.
\subsection{Identifying tokens}{

The DCT only works on a by-token basis, so there must be a column that
uniquely identifies (or, in combination with a \code{.by} grouping, uniquely
identifies) each individual token. This column should be passed to
\code{.token_id_col}.
}

\subsection{Order}{

The number of DCT coefficients to return is defined by \code{.order}. The default
value is 5. Larger numbers will lead to less smoothing when the Inverse
DCT is applied (see \link{idct}). Smaller numbers will lead to more smoothing.

If \code{NA} is passed to \code{.order}, all DCT parameters will be returned, which
when the Inverse DCT is supplied, will completely reconstruct the original
data.
}

\subsection{Sorting by Time}{

An optional \code{.time_col} can also be defined to ensure that the data is
correctly arranged by time.
}
}
\examples{
library(tidynorm)
library(dplyr)

speaker_small <- filter(
  speaker_tracks,
  id == 0
)

speaker_dct <- reframe_with_dct(
  speaker_small,
  F1:F3,
  .by = speaker,
  .token_id_col = id,
  .time_col = t
)

head(
  speaker_dct
)
}
