% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project_status}
\alias{project_status}
\title{Display Project Status}
\usage{
project_status(project, con = NULL)
}
\arguments{
\item{project}{Character string specifying the project name.}

\item{con}{An optional database connection. If NULL, a new connection is
created and closed automatically.}
}
\value{
Invisibly returns NULL. Called for side effects (printing status).
}
\description{
Prints a summary of project status including whether it's running and
the current status of all tasks.
}
\details{
Displays:
\itemize{
  \item Whether the project is running or stopped
  \item Task status summary from \code{\link{task_status}}
}

Use this function to monitor progress and identify failed tasks.
}
\examples{
\dontrun{
# Not run:
# Check project status
project_status("simulation_study")
}
}
\seealso{
\code{\link{task_status}}, \code{\link{project_get}}
}
