% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinning_til_n.R
\name{thinning_til_n}
\alias{thinning_til_n}
\title{Applies thinning to pairs of coordinates until reaching a given n}
\usage{
thinning_til_n(
  xy,
  n = 30,
  distance.step = NULL
)
}
\arguments{
\item{xy}{A data frame with columns named "x" and "y" representing geographic coordinates. Default: \code{NULL}}

\item{n}{Integer, number of samples to obtain. Must be lower than \code{nrow(xy)}. Default: \code{30}}

\item{distance.step}{Numeric, distance step used during the thinning iterations. If \code{NULL}, the one percent of the maximum distance among points in \code{xy} is used. Default: \code{NULL}}
}
\value{
A data frame with the same columns as xy with a row number close to n.
}
\description{
Resamples a set of points with x and y coordinates by increasing the distance step by step until a given sample size is obtained.
}
\examples{

data(plants_xy)

y <- thinning_til_n(
  xy = plants_xy,
  n = 10
)

if (interactive()) {
  plot(
    plants_xy[, c("x", "y")],
    col = "blue",
    pch = 15
  )

  points(
    y[, c("x", "y")],
    col = "red",
    pch = 15,
    cex = 1.5
  )
}

}
\seealso{
\code{\link[=thinning]{thinning()}}

Other utilities: 
\code{\link{.vif_to_df}()},
\code{\link{auc}()},
\code{\link{beowulf_cluster}()},
\code{\link{objects_size}()},
\code{\link{optimization_function}()},
\code{\link{prepare_importance_spatial}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{setup_parallel_execution}()},
\code{\link{standard_error}()},
\code{\link{statistical_mode}()},
\code{\link{thinning}()}
}
\concept{utilities}
