% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_moran.R
\name{get_moran}
\alias{get_moran}
\title{Extract Moran's I test results for model residuals}
\usage{
get_moran(model)
}
\arguments{
\item{model}{Model object from \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
Data frame with Moran's I statistics at multiple distance thresholds. Columns include \code{distance.threshold}, \code{moran.i} (statistic), \code{p.value}, \code{interpretation}, and \code{method}.
}
\description{
Extracts Moran's I test results for spatial autocorrelation in model residuals from models fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
Moran's I tests for spatial autocorrelation in model residuals. Significant positive values indicate residuals are spatially clustered, suggesting the model hasn't fully captured spatial patterns. For spatial models (\code{\link[=rf_spatial]{rf_spatial()}}), low or non-significant Moran's I values indicate successful removal of spatial autocorrelation.
}
\examples{
data(plants_rf)

# Extract Moran's I test results
moran_results <- get_moran(plants_rf)
moran_results

# Check for significant spatial autocorrelation
significant <- moran_results[moran_results$p.value < 0.05, ]
significant

}
\seealso{
\code{\link[=moran]{moran()}}, \code{\link[=moran_multithreshold]{moran_multithreshold()}}, \code{\link[=plot_moran]{plot_moran()}}, \code{\link[=print_moran]{print_moran()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
