% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum_utilities.R
\name{getRough}
\alias{getRough}
\title{Calculate roughness from modulation spectrum}
\usage{
getRough(m, roughRange = c(30, 150), roughMean = NULL, roughSD = NULL)
}
\arguments{
\item{m}{numeric matrix of non-negative values with colnames giving temporal
modulation frequency}

\item{roughRange}{the range of temporal modulation frequencies that
constitute the "roughness" zone, Hz}

\item{roughMean, roughSD}{the mean (Hz) and standard deviation (semitones) of
a lognormal distribution used to weight roughness estimates. If either is
null, roughness is calculated simply as the proportion of spectrum within
\code{roughRange}. If both \code{roughMean} and \code{roughRange} are
defined, weights outside \code{roughRange} are set to 0; a very large SD (a
flat weighting function) gives the same result as just \code{roughRange}
without any weighting (see examples)}
}
\value{
Returns roughness in percent.
}
\description{
Internal soundgen function
}
\details{
Helper function for calculating roughness - the proportion of energy /
amplitude in the roughness range
}
\examples{
m = modulationSpectrum(soundgen(jitterDep = 2, addSilence = 0),
  samplingRate = 16000)$original
# proportion within roughRange
plot(soundgen:::getRough(m, roughRange = c(30, Inf))[, 1:2])
plot(soundgen:::getRough(m, roughRange = c(30, 150))[, 1:2])

# lognormal weighting function instead of roughRange
plot(soundgen:::getRough(m, roughRange = NULL,
  roughMean = 75, roughSD = 1)[, 1:2])  # narrow
plot(soundgen:::getRough(m, roughRange = NULL,
  roughMean = 75, roughSD = 5000)[, 1:2])  # very broad

# lognormal weighting function truncated at roughRange
plot(soundgen:::getRough(m, roughRange = c(30, 150),
  roughMean = 75, roughSD = 3)[, 1:2])
plot(soundgen:::getRough(m, roughRange = c(30, 150),
  roughMean = 75, roughSD = 5000)[, 1:2])
# approaches proportion in roughRange as SD --> Inf

# a nice plot weighting by amplitude
r2 = soundgen:::getRough(m)
plot(r2$freq, r2$rough, cex = r2$amp ^ 2 + .25)
sum(r2$rough)  # simple sum across all bands
sum(r2$rough * r2$amp / sum(r2$amp))  # amplitude-weighted mean
# log-amplitude-weighted mean
sum(r2$rough * log(r2$amp+1e-6) / sum(log(r2$amp+1e-6)))
}
\keyword{internal}
