% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{as.LDA}
\alias{as.LDA}
\alias{as.LDA.STM}
\alias{as.LDA.LDA_Gibbs}
\alias{as.LDA.LDA_VEM}
\alias{as.LDA.textmodel_lda}
\alias{as.LDA_lda}
\alias{as.LDA.keyATM_output}
\title{Conversions from other packages to LDA}
\usage{
as.LDA(x, ...)

\method{as.LDA}{STM}(x, docs, ...)

\method{as.LDA}{LDA_Gibbs}(x, docs, ...)

\method{as.LDA}{LDA_VEM}(x, docs, ...)

\method{as.LDA}{textmodel_lda}(x, ...)

as.LDA_lda(list, docs, alpha, eta)

\method{as.LDA}{keyATM_output}(x, docs, ...)
}
\arguments{
\item{x}{an estimated topic model from \pkg{stm}, \pkg{topicmodels} or
\pkg{seededlda}.}

\item{...}{arguments passed to other methods.}

\item{docs}{for some objects, the documents used to initialize the model.}

\item{list}{the list containing an estimated model from \pkg{lda}.}

\item{alpha}{for \pkg{lda} models, the document-topic mixture hyperparameter.
If missing, the hyperparameter will be set to \code{50/K}.}

\item{eta}{for \pkg{lda} models, the topic-word mixture hyperparameter. Other
packages refer to this hyperparameter as \emph{beta}. If missing, the
hyperparameter will be set to \code{0.01}.}
}
\value{
A S3 list of class \code{LDA}, as if it was created and estimated using
\code{\link[=LDA]{LDA()}} and \code{\link[=fit.sentopicmodel]{fit()}}.
}
\description{
These functions converts estimated models from other topic
modeling packages to the format used by \pkg{sentopics}.
}
\details{
Some models do not store the topic assignment of each word (for
example, estimated through variational inference). For these, the
conversion is limited and some functionalities of \pkg{sentopics} will be
disabled. The list of affected functions is subject to change and currently
includes \code{\link[=fit.sentopicmodel]{fit()}}, \code{\link[=mergeTopics]{mergeTopics()}} and \code{\link[=rJST.LDA]{rJST.LDA()}}.

Since models from the \pkg{lda} package are simply lists of outputs, the
function \code{as.LDA_lda()} is not related to the other methods and should be
applied directly on lists containing a model.
}
\examples{
\donttest{
## stm
library("stm")
stm <- stm(poliblog5k.docs, poliblog5k.voc, K=25,
           prevalence=~rating, data=poliblog5k.meta,
           max.em.its=2, init.type="Spectral")
as.LDA(stm, docs = poliblog5k.docs)

## lda
library("lda")
data("cora.documents")
data("cora.vocab")
lda <- lda.collapsed.gibbs.sampler(cora.documents,
                                   5, ## Num clusters
                                   cora.vocab,
                                   100, ## Num iterations
                                   0.1,
                                   0.1)
LDA <- as.LDA_lda(lda, docs = cora.documents, alpha = .1, eta = .1)

## topicmodels
data("AssociatedPress", package = "topicmodels")
lda <- topicmodels::LDA(AssociatedPress[1:20,],
                        control = list(alpha = 0.1), k = 2)
LDA <- as.LDA(lda, docs = AssociatedPress[1:20,])

## seededlda
library("quanteda")
library("seededlda")
lda <- textmodel_lda(dfm(ECB_press_conferences_tokens),
                     k = 6, max_iter = 100)
LDA <- as.LDA(lda)

## keyATM
library("keyATM")
data(keyATM_data_bills, package = "keyATM")
keyATM_docs <- keyATM_read(keyATM_data_bills$doc_dfm)
out <- keyATM(docs = keyATM_docs, model = "base",
              no_keyword_topics = 5,
              keywords = keyATM_data_bills$keywords)
LDA <- as.LDA(out, docs = keyATM_docs)
}
}
