% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ne_countries.R
\name{ne_countries}
\alias{ne_countries}
\alias{ne_admin0}
\title{Get natural earth world country polygons}
\usage{
ne_countries(
  scale = 110L,
  type = "countries",
  continent = NULL,
  country = NULL,
  geounit = NULL,
  sovereignty = NULL,
  returnclass = c("sf", "sv")
)
}
\arguments{
\item{scale}{The scale of map to return, one of `110`, `50`, `10` or `small`,
`medium`, `large`.}

\item{type}{country type, one of 'countries', 'map_units', 'sovereignty',
'tiny_countries'}

\item{continent}{a character vector of continent names to get countries from.}

\item{country}{a character vector of country names.}

\item{geounit}{a character vector of geounit names.}

\item{sovereignty}{a character vector of sovereignty names.}

\item{returnclass}{A string determining the spatial object to return. Either
"sf" for for simple feature (from `sf`, the default) or "sv" for a
`SpatVector` (from `terra`).}
}
\value{
An object of class `sf` for simple feature (from `sf`, the default)
or `SpatVector` (from `terra`).
}
\description{
returns world country polygons at a specified scale, or points of
tiny_countries
}
\details{
Note that the filename of the requested object will be returned if
`load = FALSE`.

If the data is to be loaded into memory (`load = TRUE`), the download will
be handled using the GDAL virtual file system, allowing direct access to the
data without writing it to disk.
}
\examples{
world <- ne_countries()
africa <- ne_countries(continent = "africa")
france <- ne_countries(country = "france")

plot(world$geometry)
plot(africa$geometry)
plot(france$geometry)

# get as SpatVector
world <- ne_countries(returnclass = "sv")
terra::plot(world)

tiny_countries <- ne_countries(type = "tiny_countries", scale = 50)
plot(tiny_countries)

}
\seealso{
\code{\link{ne_load}}, pre-downloaded data are available using
  \code{\link{ne_countries}}, \code{\link{ne_states}}. Other geographic data
  are available in the raster package : \code{\link[raster]{getData}}.
}
