% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert_spatial_class}
\alias{convert_spatial_class}
\title{Convert from/to sf/sv objects}
\usage{
convert_spatial_class(x, returnclass = c("sf", "sv"))
}
\arguments{
\item{x}{Object to be converted}

\item{returnclass}{A string determining the spatial object to return. Either
"sf" for for simple feature (from `sf`, the default) or "sv" for a
`SpatVector` (from `terra`).}
}
\value{
Object of class "sf" or "sv"
}
\description{
returns downloaded data as a spatial object or the filename if
\code{load=FALSE}. if \code{destdir} is specified the data can be reloaded in
a later R session using \code{\link{ne_load}} with the same arguments.
}
\details{
Note that the filename of the requested object will be returned if
`load = FALSE`.

If the data is to be loaded into memory (`load = TRUE`), the download will
be handled using the GDAL virtual file system, allowing direct access to the
data without writing it to disk.
}
\examples{
\dontrun{
spdf_world <- ne_download(scale = 110, type = "countries")

plot(spdf_world)
plot(ne_download(type = "populated_places"))

# reloading from the saved file in the same session with same arguments

spdf_world2 <- ne_load(scale = 110, type = "countries")

# download followed by load from specified directory will work across sessions
spdf_world <- ne_download(scale = 110, type = "countries", destdir = getwd())
spdf_world2 <- ne_load(scale = 110, type = "countries", destdir = getwd())

# for raster, here an example with Manual Shaded Relief (MSR) download & load

rst <- ne_download(scale = 50, type = "MSR_50M", category = "raster", destdir = getwd())

# load after having downloaded
rst <- ne_load(
  scale = 50, type = "MSR_50M", category = "raster", destdir = getwd()
)

# plot
library(terra)
terra::plot(rst)
# end dontrun
}

}
\seealso{
\code{\link{ne_load}}, pre-downloaded data are available using
  \code{\link{ne_countries}}, \code{\link{ne_states}}. Other geographic data
  are available in the raster package : \code{\link[raster]{getData}}.
}
