% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-utils.R
\name{id_vars}
\alias{id_vars}
\alias{id_var}
\alias{id_col}
\alias{index_var}
\alias{index_col}
\alias{dur_var}
\alias{dur_col}
\alias{dur_unit}
\alias{meta_vars}
\alias{data_vars}
\alias{data_var}
\alias{data_col}
\alias{interval}
\alias{time_unit}
\alias{time_step}
\alias{time_vars}
\title{ICU class meta data utilities}
\usage{
id_vars(x)

id_var(x)

id_col(x)

index_var(x)

index_col(x)

dur_var(x)

dur_col(x)

dur_unit(x)

meta_vars(x)

data_vars(x)

data_var(x)

data_col(x)

interval(x)

time_unit(x)

time_step(x)

time_vars(x)
}
\arguments{
\item{x}{Object to query}
}
\value{
Mostly column names as character vectors, in case of \code{id_var()},
\code{index_var()}, \code{data_var()} and \code{time_unit()} of length 1, else of variable
length. Functions \code{id_col()}, \code{index_col()} and \code{data_col()} return table
columns as vectors, while \code{interval()} returns a scalar valued \code{difftime}
object and \code{time_step()} a number.
}
\description{
The two data classes \code{id_tbl} and \code{ts_tbl}, used by \code{ricu} to represent ICU
patient data, consist of a \code{data.table} alongside some meta data. This
includes marking columns that have special meaning and for data
representing measurements ordered in time, the step size. The following
utility functions can be used to extract columns and column names with
special meaning, as well as query a \code{ts_tbl} object regarding its time
series related meta data.
}
\details{
The following functions can be used to query an object for columns or
column names that represent a distinct aspect of the data:
\itemize{
\item \code{id_vars()}: ID variables are one or more column names with the
interaction of corresponding columns identifying a grouping of the data.
Most commonly this is some sort of patient identifier.
\item \code{id_var()}: This function either fails or returns a string and can
therefore be used in case only a single column provides grouping
information.
\item \code{id_col()}: Again, in case only a single column provides grouping
information, this column can be extracted using this function.
\item \code{index_var()}: Suitable for use as index variable is a column that encodes
a temporal ordering of observations as \code{\link[base:difftime]{difftime}}
vector. Only a single column can be marked as index variable and this
function queries a \code{ts_tbl} object for its name.
\item \code{index_col()}: similarly to \code{id_col()}, this function extracts the column
with the given designation. As a \code{ts_tbl} object is required to have
exactly one column marked as index, this function always returns for
\code{ts_tbl} objects (and fails for \code{id_tbl} objects).
\item \code{dur_var()}: For \code{win_tbl} objects, this returns the name of the column
encoding the data validity interval.
\item \code{dur_col()}: Similarly to \code{index_col()}, this returns the \code{difftime}
vector corresponding to the \code{dur_var()}.
\item \code{meta_vars()}: For \code{ts_tbl} objects, meta variables represent the union
of ID and index variables (for \code{win_tbl}, this also includes the
\code{dur_var()}), while for \code{id_tbl} objects meta variables consist pf ID
variables.
\item \code{data_vars()}: Data variables on the other hand are all columns that are
not meta variables.
\item \code{data_var()}: Similarly to \code{id_var()}, this function either returns the
name of a single data variable or fails.
\item \code{data_col()}: Building on \code{data_var()}, in situations where only a single
data variable is present, it is returned or if multiple data column
exists, an error is thrown.
\item \code{time_vars()}: Time variables are all columns in an object inheriting
from \code{\link[base:data.frame]{data.frame}} that are of type
\code{\link[base:difftime]{difftime}}. Therefore in a \code{ts_tbl} object the index
column is one of (potentially) several time variables. For a \code{win_tbl},
however the \code{dur_var()} is not among the \code{time_vars()}.
\item \code{interval()}: The time series interval length is represented a scalar
valued \code{\link[base:difftime]{difftime}} object.
\item \code{time_unit()}: The time unit of the time series interval, represented by
a string such as "hours" or "mins" (see \code{\link[base:difftime]{difftime}}).
\item \code{time_step()}: The time series step size represented by a numeric value
in the unit as returned by \code{time_unit()}.
}
}
\examples{
tbl <- id_tbl(a = rep(1:2, each = 5), b = rep(1:5, 2), c = rnorm(10),
              id_vars = c("a", "b"))

id_vars(tbl)
tryCatch(id_col(tbl), error = function(...) "no luck")
data_vars(tbl)
data_col(tbl)

tmp <- as_id_tbl(tbl, id_vars = "a")
id_vars(tmp)
id_col(tmp)

tbl <- ts_tbl(a = rep(1:2, each = 5), b = hours(rep(1:5, 2)), c = rnorm(10))
index_var(tbl)
index_col(tbl)

identical(index_var(tbl), time_vars(tbl))

interval(tbl)
time_unit(tbl)
time_step(tbl)

}
