% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{as_distance}
\alias{as_distance}
\title{Distance in kilometers or miles between two locations based on lat-long
Function based on \url{http://www.movable-type.co.uk/scripts/latlong.html}. Uses the haversine formula}
\usage{
as_distance(
  lat1,
  long1,
  lat2,
  long2,
  unit = "km",
  R = c(km = 6371, miles = 3959)[[unit]]
)
}
\arguments{
\item{lat1}{Latitude of location 1}

\item{long1}{Longitude of location 1}

\item{lat2}{Latitude of location 2}

\item{long2}{Longitude of location 2}

\item{unit}{Measure kilometers ("km", default) or miles ("miles")}

\item{R}{Radius of the earth}
}
\value{
Distance between two points
}
\description{
Distance in kilometers or miles between two locations based on lat-long
Function based on \url{http://www.movable-type.co.uk/scripts/latlong.html}. Uses the haversine formula
}
\examples{
as_distance(32.8245525, -117.0951632, 40.7033127, -73.979681, unit = "km")
as_distance(32.8245525, -117.0951632, 40.7033127, -73.979681, unit = "miles")

}
