% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{create_modelling_data}
\alias{create_modelling_data}
\title{Data Preparation and Formatting for Modelling}
\usage{
create_modelling_data(data, columns)
}
\arguments{
\item{data}{data.frame The data to format}

\item{columns}{vector The columns to target}
}
\value{
List with all the appropriate things needed
for modelling with JAGS
}
\description{
Create the needed list that gets based to the JAGS
backend for modelling. This should be a standard
data.frame object that can then be standardized and
reshaped into a format appropriate for modeling.
Errors will be thrown if the data is not a class,
or inherit from, a data.frame or if the specified
columns do not exist in the data.frame.
}
\examples{
data <- data.frame(
 list(
   "BMI" = rnorm(100, mean = 0, sd = 1),
   "fruit" = rnorm(100, mean = 0, sd = 1),
   "veg" = rnorm(100, mean = 0, sd = 1),
   "tobacco" = rnorm(100, mean = 0, sd = 1)
 )
)
create_modelling_data(data, c("BMI", "fruit", "veg", "tobacco"))
}
