% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_density.R
\name{detect_density}
\alias{detect_density}
\title{Detect Density-Based Anomalies (LOF)}
\usage{
detect_density(data, k = 5, threshold = 1.5)
}
\arguments{
\item{data}{A data frame (only numeric columns will be used).}

\item{k}{Integer. The number of neighbors to consider. Defaults to 5.}

\item{threshold}{Numeric. The LOF score cutoff. Values > 1 indicate potential outliers. Defaults to 1.5.}
}
\value{
A data frame with the outliers and their LOF score.
}
\description{
Uses the Local Outlier Factor (LOF) algorithm to identify anomalies based on local density.
It is useful for detecting outliers in multi-dimensional data that Z-score misses.
}
\examples{
df <- data.frame(x = c(rnorm(50), 5), y = c(rnorm(50), 5))
detect_density(df, k = 5)
}
