% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_hyper.R
\name{tune_hyper}
\alias{tune_hyper}
\title{Generate Probability Samples for Voting "Yes"}
\usage{
tune_hyper(hyperparams = hyperparams, n_leg, n_issue)
}
\arguments{
\item{hyperparams}{A list of hyperparameter values:
- `beta_mean`: The prior mean of the `beta` parameter, representing legislator positions.
- `beta_var`: The prior variance of `beta`.
- `alpha_mean`: A vector of length two, specifying the prior means of the item discrimination parameters, `alpha1` and `alpha2`.
- `alpha_scale`: The scale parameter for `alpha1` and `alpha2`.
- `delta_mean`: A vector of length two, indicating the prior means of the item difficulty parameters, `delta1` and `delta2`.
- `delta_scale`: The scale parameter for `delta1` and `delta2`.}

\item{n_leg}{Integer, representing the number of legislators (members) to be simulated.}

\item{n_issue}{Integer, indicating the number of issues to be simulated.}
}
\value{
A numeric vector containing the simulated probabilities of voting "Yes" for legislators across issues.
}
\description{
This function generates probability samples for Voting "Yes".
It uses predefined hyperparameters and simulates data based on the specified number of members (`n_leg`) and issues (`n_issue`).
}
\examples{
hyperparams = list(beta_mean = 0, beta_var = 1, alpha_mean = c(0, 0),
                   alpha_scale = 5, delta_mean = c(-2, 10),
                   delta_scale = sqrt(10))
theta = tune_hyper(hyperparams, n_leg = 10, n_issue = 10)
}
