% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.phylter.R
\name{write.phylter}
\alias{write.phylter}
\title{Write summary of phyter analysis to file(s)}
\usage{
write.phylter(
  x,
  file = "",
  include.discarded = TRUE,
  pdfreport = FALSE,
  pdfreport.file = "report.pdf"
)
}
\arguments{
\item{x}{The object returned by the 'phylter()' function.}

\item{file}{Name of the file where to write the text summary of the phylter output.
If \code{""} (the default), \code{write.phylyer()} prints to the standard output.}

\item{include.discarded}{Logical. If TRUE (the default) the elements discarded before the analysis
are still in the list of Outliers in the output. Useful for cleaning datasets after a phylter analysis.}

\item{pdfreport}{Logical. Should a full report of the phylter analysis}

\item{pdfreport.file}{If \code{report=TRUE}, name of the pdf file where the 
report is written. Default to \code{report.pdf}}
}
\value{
No return value
}
\description{
Write the summary of the phylter analysis in a txt file or as a pdf report.
}
\examples{
data(carnivora) 
res <- phylter(carnivora, parallel = FALSE)
# write a full report to the standard output
write.phylter(res) 


}
