% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_utils.R
\name{swapGenotypes}
\alias{swapGenotypes}
\title{Swap genotypes between individuals}
\usage{
swapGenotypes(x, ids = NULL)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{ids}{A vector of 2 members of \code{x}.}
}
\value{
An object identical to \code{x}, except that the genotypes of the \code{ids}
pair have been swapped.
}
\description{
Swap genotypes between individuals
}
\examples{
x = nuclearPed() |>
  addMarker(geno = c("1/1", "2/2", "3/3"))

swapGenotypes(x, ids = 1:2)

}
\seealso{
\code{\link[=transferMarkers]{transferMarkers()}}
}
