% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers_stream.R
\name{paws_stream}
\alias{paws_stream}
\alias{paws_stream_handler}
\alias{paws_stream_parser}
\title{Iterate over AWS Event Stream connection}
\usage{
paws_stream_handler(FUN, .connection = FALSE)

paws_stream_parser(con)
}
\arguments{
\item{FUN}{function to iterate over stream connection.}

\item{.connection}{return \code{paws_connection} object a subclass of \code{httr2::req_perform_connection} (default \code{FALSE})}

\item{con}{A streaming response created by \code{paws_stream_handler}.}
}
\value{
list of responses from the operation or a \code{paws_connection} object
}
\description{
Iterate over AWS Event Stream connection
}
\examples{
\dontrun{
# Developed from:
# https://docs.aws.amazon.com/code-library/latest/ug/python_3_bedrock-runtime_code_examples.html
library(paws)

# Create a Bedrock Runtime client in the AWS Region you want to use.
client <- bedrockruntime(region = "us-east-1")

# Set the model ID, e.g., Titan Text Premier.
model_id <- "amazon.titan-text-premier-v1:0"

# Start a conversation with the user message.
user_message <- "Describe the purpose of a 'hello world' program in one line."
conversation <- list(
  list(
    role = "user",
    content = list(list(text = user_message))
  )
)

resp <- client$converse_stream(
  modelId = model_id,
  messages = conversation,
  inferenceConfig = list(maxTokens = 512, temperature = 0.5, topP = 0.9)
)
resp$stream(\(chunk) chunk$contentBlockDelta$delta$text)
# Note: stream will close connection after all chunks are read

# Get connection object
resp <- client$converse_stream(
  modelId = model_id,
  messages = conversation,
  inferenceConfig = list(maxTokens = 512, temperature = 0.5, topP = 0.9)
)
con <- resp$stream(.connection = T)

# Handle connection object using paws_stream_parser
while (!is.null(chunk <- paws_stream_parser(con))) {
  print(chunk$contentBlockDelta$delta$text)
}

# Note: paws_stream_parser will close connection after all chunks are read

resp <- client$converse_stream(
  modelId = model_id,
  messages = conversation,
  inferenceConfig = list(maxTokens = 512, temperature = 0.5, topP = 0.9)
)

# Or handle connection using httr2::resp_stream_aws
while (!is.null(chunk <- resp_stream_aws(con))) {
  str(chunk)
}
close(con)

# Note: connection needs to be closed manually after all chunks have been read.
}
}
