% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes_manifest.R
\name{nhanesManifest}
\alias{nhanesManifest}
\title{Download and parse NHANES manifests}
\usage{
nhanesManifest(
  which = c("public", "limitedaccess", "variables"),
  sizes = FALSE,
  dxa = FALSE,
  component = NULL,
  verbose = getOption("verbose"),
  use_cache = TRUE,
  max_age = 24 * 60 * 60
)
}
\arguments{
\item{which}{Either "public" or "limitedaccess" to get a manifest
of available tables, or "variables" to get a manifest of
available variables.}

\item{sizes}{Logical, whether to compute data file sizes (as
reported by the server) and include them in the result.}

\item{dxa}{Logical, whether to include information on DXA tables.
These tables contain imputed imputed Dual Energy X-ray
Absorptiometry measurements, and are listed separately, not in
the main listing.}

\item{component}{An optional character string specifying the
component for which the public data manifest is to be
downloaded. Valid values are \code{"demographics"},
\code{"dietary"}, \code{"examination"}, \code{"laboratory"}, and
\code{"questionnaire"}.  Partial matching is allowed, and case
is ignored. Specifying a component for the public manifest will
return a subset of the tables, but has the advantage that the
result will include a description of each table.}

\item{verbose}{Logical flag indicating whether information on
progress should be reported.}

\item{use_cache}{Logical flag indicating whether a cached version
(from a previous download in the same session) should be used.}

\item{max_age}{Maximum allowed age of the cache in seconds
(defaults to 24 hours). Cached versions that are older are
ignored, even if available.}
}
\value{
A data frame, with columns that depend on
  \code{which}.

  For a manifest of tables, columns are "Table", "DocURL",
  "DataURL", "Years", "Date.Published". If \code{component} is
  specified, an additional column "Description" giving a
  description of the table will be included. If \code{sizes =
  TRUE}, an additional column "DataSize" giving the data file
  sizes in bytes (as reported by the server) is included.

  For limited access tables, the "DataURL" and "DataSize" columns
  are omitted.

  For a manifest of variables, columns are "VarName", "VarDesc",
  "Table", "TableDesc", "BeginYear", "EndYear", "Component", and
  "UseConstraints".
}
\description{
Downloads and parses NHANES manifests for data tables and
variables, and returns them as data frames.
}
\details{
The NHANES website maintains several listings (manifests) of
tables and associated variables, which can be downloaded using these functions.

The list of tables for which data is available publicly can be
found at
\url{https://wwwn.cdc.gov/Nchs/Nhanes/search/DataPage.aspx}, with
further restriction to specific components possible by specifying
an additional query parameter as below. This is the \emph{public}
manifest.

Limited access tables (also referred to as RDC only tables) are
listed at
\url{https://wwwn.cdc.gov/Nchs/Nhanes/search/DataPage.aspx?Component=LimitedAccess}.
This is the \emph{limited access} manifest.

Available variables are listed according to component at
\url{https://wwwn.cdc.gov/nchs/nhanes/search/variablelist.aspx?Component=Demographics},
etc. These are the \emph{variable} manifests.
}
\note{
Duplicate rows are removed from the result. Most of these
  duplicates arise from duplications in the source tables for
  multi-cycle tables (which are repeated once for each cycle). One
  special case is the WHQ table which has two variables, WHD120
  and WHQ030, duplicated with differing variable
  descriptions. These are removed explicitly, keeping only the
  first occurrence.
}
\examples{
\donttest{
## May fail if CDC website is (available but) malformatted
try({
    manifest <- nhanesManifest(sizes = FALSE)
    dim(manifest)
})
try({
    varmf <- nhanesManifest("variables", component = "lab")
    head(varmf)
})
}

}
