% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerBatchIrace.R
\name{mlr_tuners_irace}
\alias{mlr_tuners_irace}
\alias{TunerBatchIrace}
\title{Hyperparameter Tuning with Iterated Racing.}
\source{
Lopez-Ibanez M, Dubois-Lacoste J, Caceres LP, Birattari M, Stuetzle T (2016).
\dQuote{The irace package: Iterated racing for automatic algorithm configuration.}
\emph{Operations Research Perspectives}, \bold{3}, 43--58.
\doi{https://doi.org/10.1016/j.orp.2016.09.002}.
}
\description{
Subclass for iterated racing.
Calls \code{\link[irace:irace]{irace::irace()}} from package \CRANpkg{irace}.
}
\section{Dictionary}{

This \link{Tuner} can be instantiated with the associated sugar function \code{\link[=tnr]{tnr()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tnr("irace")
}\if{html}{\out{</div>}}
}

\section{Control Parameters}{

\describe{
\item{\code{n_instances}}{\code{integer(1)}\cr
Number of resampling instances.}
}

For the meaning of all other parameters, see \code{\link[irace:defaultScenario]{irace::defaultScenario()}}. Note
that we have removed all control parameters which refer to the termination of
the algorithm. Use \link[bbotk:mlr_terminators_evals]{bbotk::TerminatorEvals} instead. Other terminators do not work
with \code{TunerIrace}.
}

\section{Archive}{

The \link{ArchiveBatchTuning} holds the following additional columns:
\itemize{
\item \code{"race"} (\code{integer(1)})\cr
Race iteration.
\item \code{"step"} (\code{integer(1)})\cr
Step number of race.
\item \code{"instance"} (\code{integer(1)})\cr
Identifies resampling instances across races and steps.
\item \code{"configuration"} (\code{integer(1)})\cr
Identifies configurations across races and steps.
}
}

\section{Result}{

The tuning result (\code{instance$result}) is the best-performing elite of the final race.
The reported performance is the average performance estimated on all used instances.
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link[bbotk:Terminator]{bbotk::Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\section{Logging}{

All \link{Tuner}s use a logger (as implemented in \CRANpkg{lgr}) from package
\CRANpkg{bbotk}.
Use \code{lgr::get_logger("bbotk")} to access and control the logger.
}

\section{Optimizer}{

This \link{Tuner} is based on \link[bbotk:mlr_optimizers_irace]{bbotk::OptimizerBatchIrace} which can be applied on any black box optimization problem.
See also the documentation of \href{https://bbotk.mlr-org.com/}{bbotk}.
}

\section{Resources}{

There are several sections about hyperparameter optimization in the \href{https://mlr3book.mlr-org.com}{mlr3book}.
\itemize{
\item Getting started with \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html}{hyperparameter optimization}.
\item An overview of all tuners can be found on our \href{https://mlr-org.com/tuners.html}{website}.
\item \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-model-tuning}{Tune} a support vector machine on the Sonar data set.
\item Learn about \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-defining-search-spaces}{tuning spaces}.
\item Estimate the model performance with \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-nested-resampling}{nested resampling}.
\item Learn about \href{https://mlr3book.mlr-org.com/chapters/chapter5/advanced_tuning_methods_and_black_box_optimization.html#sec-multi-metrics-tuning}{multi-objective optimization}.
\item Simultaneously optimize hyperparameters and use \href{https://mlr3book.mlr-org.com/chapters/chapter15/predsets_valid_inttune.html}{early stopping} with XGBoost.
\item \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-autotuner}{Automate} the tuning.
}

The \href{https://mlr-org.com/gallery-all-optimization.html}{gallery} features a collection of case studies and demos about optimization.
\itemize{
\item Learn more advanced methods with the \href{https://mlr-org.com/gallery/series/2021-03-09-practical-tuning-series-tune-a-support-vector-machine/}{Practical Tuning Series}.
\item Learn about \href{https://mlr-org.com/gallery/optimization/2023-01-16-hotstart/}{hotstarting} models.
\item Run the \href{https://mlr-org.com/gallery/optimization/2023-01-31-default-configuration/}{default hyperparameter configuration} of learners as a baseline.
\item Use the \href{https://mlr-org.com/gallery/series/2023-01-15-hyperband-xgboost/}{Hyperband} optimizer with different budget parameters.
}

The \href{https://cheatsheets.mlr-org.com/mlr3tuning.pdf}{cheatsheet} summarizes the most important functions of mlr3tuning.
}

\examples{
# example only runs if irace is available
if (mlr3misc::require_namespaces("irace", quietly = TRUE)) {
# retrieve task
task = tsk("pima")

# load learner and set search space
learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE))

# runtime of the example is too long
\donttest{
# hyperparameter tuning on the pima indians diabetes data set
instance = tune(
  tuner = tnr("irace"),
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  term_evals = 200
)

# best performing hyperparameter configuration
instance$result

# all evaluated hyperparameter configuration
as.data.table(instance$archive)

# fit final model on complete data set
learner$param_set$values = instance$result_learner_param_vals
learner$train(task)
}}
}
\seealso{
Other Tuner: 
\code{\link{Tuner}},
\code{\link{mlr_tuners}},
\code{\link{mlr_tuners_cmaes}},
\code{\link{mlr_tuners_design_points}},
\code{\link{mlr_tuners_gensa}},
\code{\link{mlr_tuners_grid_search}},
\code{\link{mlr_tuners_internal}},
\code{\link{mlr_tuners_nloptr}},
\code{\link{mlr_tuners_random_search}}
}
\concept{Tuner}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerBatch]{mlr3tuning::TunerBatch}} -> \code{\link[mlr3tuning:TunerBatchFromOptimizerBatch]{mlr3tuning::TunerBatchFromOptimizerBatch}} -> \code{TunerBatchIrace}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerBatchIrace-new}{\code{TunerBatchIrace$new()}}
\item \href{#method-TunerBatchIrace-optimize}{\code{TunerBatchIrace$optimize()}}
\item \href{#method-TunerBatchIrace-clone}{\code{TunerBatchIrace$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-print'><code>mlr3tuning::Tuner$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerBatchIrace-new"></a>}}
\if{latex}{\out{\hypertarget{method-TunerBatchIrace-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerBatchIrace$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerBatchIrace-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-TunerBatchIrace-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the tuning on a \link{TuningInstanceBatchSingleCrit} until termination.
The single evaluations and the final results will be written into the
\link{ArchiveBatchTuning} that resides in the \link{TuningInstanceBatchSingleCrit}. The final
result is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerBatchIrace$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{TuningInstanceBatchSingleCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerBatchIrace-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerBatchIrace-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerBatchIrace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
