% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchActivation.R
\name{nn_geglu}
\alias{nn_geglu}
\title{GeGLU Module}
\usage{
nn_geglu()
}
\description{
This module implements the Gaussian Error Linear Unit Gated Linear Unit (GeGLU) activation function.
It computes \eqn{\text{GeGLU}(x, g) = x \cdot \text{GELU}(g)}
where \(x\) and \(g\) are created by splitting the input tensor in half along the last dimension.
}
\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
x = torch::torch_randn(10, 10)
glu = nn_geglu()
glu(x)
\dontshow{\}) # examplesIf}
}
\references{
Shazeer N (2020).
\dQuote{GLU Variants Improve Transformer.}
2002.05202, \url{https://arxiv.org/abs/2002.05202}.
}
