% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_proximity.MetaForest.R
\name{extract_proximity}
\alias{extract_proximity}
\title{Extract proximity matrix for a MetaForest object.}
\usage{
extract_proximity(fit, newdata)
}
\arguments{
\item{fit}{object of class \'MetaForest\'.}

\item{newdata}{new data with the same columns as the data used for \code{fit}}
}
\value{
an n x n matrix where position i, j gives the proportion of times
observation i and j are in the same terminal node across all trees.
}
\description{
Extract proximity matrix for a MetaForest object.
}
\examples{
\dontshow{
set.seed(42)
data <- SimulateSMD(k_train = 100, distribution = "bernoulli", model = es *
                    x[,1]*x[,2])
#Conduct unweighted MetaForest analysis
mf.unif <- MetaForest(formula = yi ~ ., data = data$training,
                      whichweights = "unif", method = "DL")
prox_matrix <- extract_proximity(mf.unif)
}
}
