% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvRegularizeSEMInternal.R
\name{cvScaler}
\alias{cvScaler}
\title{cvScaler}
\usage{
cvScaler(testSet, means, standardDeviations)
}
\arguments{
\item{testSet}{test data set}

\item{means}{means of the training set}

\item{standardDeviations}{standard deviations of the training set}
}
\value{
scaled test set
}
\description{
uses the means and standard deviations of the training set to standardize
the test set. See, e.g., https://scikit-learn.org/stable/modules/cross_validation.html .
}
\examples{
library(lessSEM)
data <- matrix(rnorm(50),10,5)

cvScaler(testSet = data, 
         means = 1:5, 
         standardDeviations = 1:5)
}
