% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{usher3}
\alias{usher3}
\title{Two-Parameter Usher Function}
\usage{
usher3(
  start_value,
  alpha,
  beta,
  time_steps = 100L,
  time_lag = 1L,
  pre0_subs = FALSE,
  pre0_value = 0,
  substoch = 0L,
  separate_N = NULL
)
}
\arguments{
\item{start_value}{A positive number to start the return vector in time 0.}

\item{alpha}{The alpha parameter in the two-parameter Usher
function.}

\item{beta}{The beta parameter in the two-parameter Usher function.}

\item{time_steps}{The number of time steps to run the projection. Must be a
positive integer.}

\item{time_lag}{A positive integer denoting the number of time steps back
for the value of phi in the two-parameter Usher function.}

\item{pre0_subs}{A logical value indicating whether to use a number other
than that given in \code{start_value} for values of phi lagged from times
prior to time 0.}

\item{pre0_value}{A positive number to use for phi lagged from times prior
to time 0. Only used if \code{pre0_subs = TRUE}.}

\item{substoch}{An integer value indicating the kind of substochasticity to
use. Values include: \code{0}, no substochasticity enforced (the default);
\code{1}, all numbers must be non-negative; and \code{2}, all numbers should
be forced to the interval [0, 1].}

\item{separate_N}{An optional numeric vector with values of N in each time,
if phi is to be treated as different from N in the two-parameter model.}
}
\value{
A numeric vector of values showing values projected under the two-
parameter Usher function.
}
\description{
Function \code{usher3()} creates a vector of values produced by the two-
parameter Usher function as applied with a user-specified time lag.
The Usher function is given as 
\eqn{\phi_{t+1} = \phi_t / (1 + e^{\alpha n_t + \beta})}. Here,
if no \code{separate_N} vector is provided, then \eqn{n_t = \phi_t}.
}
\examples{
trial_run1 <- usher3(1, alpha = -0.5, beta = 0.005)
plot(trial_run1)

trial_run2 <- usher3(1, alpha = 0.5, beta = 0.005)
plot(trial_run2)

trial_run3 <- usher3(1, alpha = -5, beta = 0.005)
plot(trial_run3)

trial_run4 <- usher3(1, alpha = 5, beta = 0.005)
plot(trial_run4)

trial_run5 <- usher3(1, alpha = -25, beta = 0.005)
plot(trial_run5)

trial_run6 <- usher3(1, alpha = 25, beta = 0.005)
plot(trial_run6)

used_Ns <- c(10, 15, 12, 14, 14, 150, 15, 1, 5, 7, 9, 14, 13, 16, 17, 19,
  25, 26)
trial_run7 <- usher3(1, alpha = -0.5, beta = 0.005, separate_N = used_Ns)
plot(trial_run7)

}
