% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lcc.R
\name{lccPlot}
\alias{lccPlot}
\title{Plot Fitted Curves from an \code{lcc} Object}
\usage{
lccPlot(obj, type = "lcc", control = list(), ...)
}
\arguments{
\item{obj}{An object inheriting from class "lcc", representing a fitted lcc model.}

\item{type}{Character string specifying the type of plot to generate. 
\itemize{
  \item \code{"lcc"}: Produces the LCC plot.
  \item \code{"lpc"}: Produces the LPC plot. Available only if \code{components = TRUE}.
  \item \code{"la"}: Produces the LA plot. Available only if \code{components = TRUE}.
}}

\item{control}{A list of graphical control values or character strings returned 
by the \code{\link{plotControl}} function. Defaults to an empty list. 
The list can contain components like \code{shape}, \code{colour}, \code{size},
\code{xlab}, \code{ylab}, \code{scale_y_continuous}, and \code{all.plot}.}

\item{...}{Additional arguments passed to the 
\code{\link[ggplot2]{facet_wrap}} function.}
}
\value{
An object of class \code{ggplot} or \code{viewport}, depending on the 
  \code{all.plot} setting in \code{control}.
}
\description{
This function generates a plot of predictions versus the time covariate for 
an \code{lcc} object. Predicted values are connected by lines, while actual 
observations are denoted by circles. If \code{components=TRUE} was used in the 
\code{lcc} object, individual plots for each statistic (LCC, LPC, and LA) are 
produced on separate pages.
}
\examples{
data(hue)
# Second degree polynomial model with random intercept, slope and quadratic term
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
          method = "Method", time = "Time", qf = 2, qr = 2, components = TRUE)
lccPlot(fm1, type = "lcc")
lccPlot(fm1, type = "lpc")
lccPlot(fm1, type = "la")

# Using ggplot2 themes
lccPlot(fm1, type = "lpc") + theme_bw() + labs(x = "Time (Days)", y = "LPC Value")

# Generating and saving plots
\dontrun{
  ggsave("lccPlot.pdf", lccPlot(fm1, type = "lcc"))
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{plotControl}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
