% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{runPCA}
\alias{runPCA}
\title{Cluster assay data by Principal Components Analysis}
\usage{
runPCA(
  TapestriExperiment,
  alt.exp = "alleleFrequency",
  assay = NULL,
  sd.min.threshold = NULL,
  center = TRUE,
  scale. = TRUE
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object}

\item{alt.exp}{Character, \code{altExp} to use, \code{NULL} uses top-level/main experiment. Default "alleleFrequency".}

\item{assay}{Character, \code{assay} to use. \code{NULL} (default) uses first-indexed assay.}

\item{sd.min.threshold}{Numeric, minimum threshold for allelefreq.sd. Increase to run PCA on fewer, more variable dimensions. Set to \code{NULL} if not using for alleleFrequency slot. Default \code{NULL}.}

\item{center}{Logical, if \code{TRUE} (default), variables are shifted to be zero centered. See \code{\link[stats:prcomp]{stats::prcomp()}}.}

\item{scale.}{Logical,if \code{TRUE} (default), variables are scaled to have unit variance prior to PCA. See \code{\link[stats:prcomp]{stats::prcomp()}}.}
}
\value{
\code{TapestriExperiment} with PCA results saved to \code{reducedDims} slot of \code{altExp}, and proportion of variance explained by each PC saved to \code{metadata} slot of \code{altExp.}
}
\description{
Analyzes assay data by Principal Components Analysis (PCA) and saves results
to \code{reducedDims} slot of \code{TapestriObject}.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment
tap.object <- runPCA(tap.object, alt.exp = "alleleFrequency")
}
\seealso{
\code{\link[stats:prcomp]{stats::prcomp()}} for PCA method details.
}
\concept{dimensional reduction}
