% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_read_confirmed.R
\name{jpinfect_read_confirmed}
\alias{jpinfect_read_confirmed}
\title{Read Confirmed Case Reports from File or Directory}
\usage{
jpinfect_read_confirmed(path, type = NULL, ...)
}
\arguments{
\item{path}{A character string specifying the path to a single file or directory containing multiple files.}

\item{type}{A character string specifying the type of data to import. Must be either \code{"sex"} or \code{"place"}.}

\item{...}{Additional arguments passed to internal functions for further customization.}
}
\value{
A data frame containing processed case reports for all rows and columns in the files.
}
\description{
This function processes case reports either from a single file or from multiple files within a directory.
The function is capable of handling data by \code{"sex"} or \code{"place"} types, and processes data
accordingly based on file patterns.
}
\details{
The function detects whether the \code{path} is a single file or a directory. If it is a single file,
it processes the data using \code{.jpinfect_read_excel}. If it is a directory, it processes multiple files
using \code{.jpinfect_read_excels}.

Supported file patterns:
\describe{
  \item{\code{"sex"}}{Files with names containing \code{"11.xls"} or \code{"Syu_01_1.xls"}.}
  \item{\code{"place"}}{Files with names containing \code{"Syu_02_1.xls"}.}
}
}
\examples{
\donttest{
# Process a single file
data_file <- system.file("extdata", "1999_Syu_11.xls", package = "jpinfect")
data_single <- jpinfect_read_confirmed(data_file)

# Process all files in a directory
data_dir <- system.file("extdata", package = "jpinfect")
data_multiple <- jpinfect_read_confirmed(data_dir, type = "place")
}

}
