% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_diversity_airr.R
\name{airr_diversity}
\alias{airr_diversity}
\alias{airr_diversity_dxx}
\alias{airr_diversity_chao1}
\alias{airr_diversity_shannon}
\alias{airr_diversity_pielou}
\alias{airr_diversity_index}
\alias{airr_diversity_hill}
\title{Diversity - estimating the heterogeneity of immune repertoires}
\usage{
airr_diversity_dxx(
  idata,
  perc = 50,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

airr_diversity_chao1(
  idata,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

airr_diversity_shannon(
  idata,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

airr_diversity_pielou(
  idata,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

airr_diversity_index(
  idata,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

airr_diversity_hill(
  idata,
  q = 0:5,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)
}
\arguments{
\item{idata}{An \code{ImmunData} object.}

\item{perc}{A number or numeric vector in \verb{(0, 100]} (default \code{50}), e.g.
\code{50} for D50, \code{20} for D20.}

\item{autojoin}{Logical. If TRUE, join repertoire metadata by the schema repertoire id.
Change the default behaviour by calling \code{options(immunarch.autojoin = FALSE)}.}

\item{format}{String. One of \code{"long"} ("long" tibble with \code{imd_repertoire_id}, facet
columns, and \code{value}; useful for visualizations) or \code{"wide"} (wide/unmelted table of features,
with each row corresponding to a specific repertoire / pair of repertoires; useful for Machine Learning).}

\item{q}{A scalar or vector of non-negative orders. Defaults to \code{0:5}.}
}
\value{
\subsection{\code{airr_diversity_dxx}}{

A tibble with:
\itemize{
\item \code{imd_repertoire_id}
\item \code{perc}
\item \code{dxx} - minimal count of top receptors to reach \verb{perc\%}
\item plus repertoire metadata from \code{idata$repertoires}
}
}

\subsection{\code{airr_diversity_chao1}}{

A tibble with:
\itemize{
\item \code{imd_repertoire_id}
\item \code{Estimator} - number of species
\item \code{SD} - standard deviation for the estimator value
\item \code{Conf.95.lo} - CI 0.025
\item \code{Conf.95.hi} - CI 0.975
\item plus repertoire metadata from \code{idata$repertoires}
}
}

\subsection{\code{airr_diversity_shannon}}{

A tibble with:
\itemize{
\item \code{imd_repertoire_id}
\item \code{shannon} - entropy in bits
}
}

\subsection{\code{airr_diversity_pielou}}{

A tibble with:
\itemize{
\item \code{imd_repertoire_id}
\item \code{shannon}
\item \code{n_receptors}
\item \code{pielou} - evenness in \verb{[0, 1]} (NA if \code{S <= 1})
}
}

\subsection{\code{airr_diversity_index}}{

A tibble with:
\itemize{
\item \code{imd_repertoire_id}
\item \code{q = 1}
\item \code{hill_number}
\item plus repertoire metadata from \code{idata$repertoires}
}
}

\subsection{\code{airr_diversity_hill}}{

A tibble with:
\itemize{
\item \code{imd_repertoire_id}
\item \code{q} - Hill order
\item \code{hill_number} - true diversity of order \code{q}
\item plus repertoire metadata from \code{idata$repertoires}
}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A family of functions to quantify \strong{receptor diversity} per repertoire. A characteristic of a whole repertoire.
\subsection{Available functions}{

Supported methods are the following.
}

\code{airr_diversity_dxx} - \strong{coverage diversity}: minimal number of
top receptors needed to reach \verb{perc\%} of clonal space (by \code{proportion}).
Great for spotting dominance/overexpansion and for quick, interpretable dashboards
(e.g., D50 = receptors to cover half of the repertoire).

\code{airr_diversity_chao1} - Chao1 estimator is a nonparameteric
asymptotic estimator of species richness (number of species in a population).
One of the most used methods for estimating immune repertoire diversity.

\code{airr_diversity_shannon} - Shannon entropy (base 2) per repertoire
computed from \code{proportion}. Ideal when you want a single evenness-aware
diversity score; pair with Pielou/Hill for samples with very different richness.

\code{airr_diversity_pielou} - Pielou's evenness \code{H / log2(S)} with
richness \code{S}. Best when you need a \strong{size-normalized} evenness score that's
comparable across repertoires with different receptor counts.

\code{airr_diversity_index} - convenience alias for Hill number with
\code{q = 1} (\code{exp(Shannon)} using natural log). A solid \strong{default single metric}
that's relatively robust to rare-count noise and easy to compare across samples.

\code{airr_diversity_hill} - Hill numbers ("true diversity") for
orders \verb{q \eqn{\in}{in} \{0, 1, 2, ...\}}: \code{q=0} richness, \code{q=1} exp(Shannon), \code{q>1}
emphasizes abundant receptors. Perfect when you want a \strong{diversity profile}
that tunes sensitivity to rare vs. abundant clonotypes.
}
\examples{
# Limit the number of threads used by the underlying DB for this session.
# Change this only if you know what you're doing (e.g., multi-user machines, shared CI/servers).
db_exec("SET threads TO 1")
# Load data
\dontrun{
immdata <- get_test_idata() |> agg_repertoires("Therapy")
}

#
# airr_diversity_dxx
#
\dontrun{
d50 <- airr_diversity_dxx(immdata, perc = 50)
d_multi <- airr_diversity_dxx(immdata, perc = c(20, 50, 80))
}

#
# airr_diversity_chao1
#
\dontrun{
chao <- airr_diversity_chao1(immdata)
}

#
# airr_diversity_shannon
#
\dontrun{
sh <- airr_diversity_shannon(immdata)
}

#
# airr_diversity_pielou
#
\dontrun{
pj <- airr_diversity_pielou(immdata)
}

#
# airr_diversity_index
#
\dontrun{
idx <- airr_diversity_index(immdata)
}

#
# airr_diversity_hill
#
\dontrun{
hill <- airr_diversity_hill(immdata, q = c(0, 1, 2))
}

}
\seealso{
\link[immundata:ImmunData]{immundata::ImmunData}
}
\concept{Diversity}
