% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralization.R
\name{centr_eigen_tmax}
\alias{centr_eigen_tmax}
\title{Theoretical maximum for eigenvector centralization}
\usage{
centr_eigen_tmax(
  graph = NULL,
  nodes = 0,
  directed = FALSE,
  scale = deprecated()
)
}
\arguments{
\item{graph}{The input graph. It can also be \code{NULL}, if
\code{nodes} is given.}

\item{nodes}{The number of vertices. This is ignored if the graph is
given.}

\item{directed}{logical scalar, whether to consider edge directions
during the calculation. Ignored in undirected graphs.}

\item{scale}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Ignored. Computing
eigenvector centralization requires normalized eigenvector centrality scores.}
}
\value{
Real scalar, the theoretical maximum (unnormalized) graph
eigenvector centrality score for graphs with given vertex count and
other parameters.
}
\description{
See \code{\link[=centralize]{centralize()}} for a summary of graph centralization.
}
\examples{
# A BA graph is quite centralized
g <- sample_pa(1000, m = 4)
centr_eigen(g, normalized = FALSE)$centralization \%>\%
  `/`(centr_eigen_tmax(g))
centr_eigen(g, normalized = TRUE)$centralization
}
\seealso{
Other centralization related: 
\code{\link{centr_betw}()},
\code{\link{centr_betw_tmax}()},
\code{\link{centr_clo}()},
\code{\link{centr_clo_tmax}()},
\code{\link{centr_degree}()},
\code{\link{centr_degree_tmax}()},
\code{\link{centr_eigen}()},
\code{\link{centralize}()}
}
\concept{centralization related}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_centralization_eigenvector_centrality_tmax}{\code{centralization_eigenvector_centrality_tmax()}}.}

