% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_band_index_by_time}
\alias{get_band_index_by_time}
\title{Get band index based on time period}
\usage{
get_band_index_by_time(time, year)
}
\arguments{
\item{time}{Character vector of length 2. (optional) Start and end dates in \code{"MM-DD"} format
(e.g., \code{c("03-20", "10-15")}). Used to subset the 10-day interval data cube by time.}

\item{year}{numeric. (required) The year of interest.}
}
\value{
Interger. a band index.
}
\description{
Converts a date string in \code{"MM-DD"} format to the corresponding band index
for the Greenspace Seasonality Data Cube, which contains 36 bands representing
10-day intervals over a year.
}
\details{
The Greenspace Data Cube is organized into 36 bands per year, each representing a 10-day interval.
This function calculates which of those bands a given date falls into by converting the MM-DD
string into the day-of-year (DOY) and dividing by 10 (rounded up).
}
\examples{
get_band_index_by_time(c("03-20", "10-15"), year = 2020)

}
