% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{get_nested_categories}
\alias{get_nested_categories}
\title{Auxiliary function to create categorical variables for nested grouped random effects}
\usage{
get_nested_categories(outer_var, inner_var)
}
\arguments{
\item{outer_var}{A \code{vector} containing the outer categorical grouping variable
within which the \code{inner_var is} nested in. Can be of type integer, double, or character.}

\item{inner_var}{A \code{vector} containing the inner nested categorical grouping variable}
}
\value{
A \code{vector} containing a categorical variable such that inner_var is nested in outer_var
}
\description{
Auxiliary function to create categorical variables for nested grouped random effects
}
\examples{
\donttest{
# Fit a model with Time as categorical fixed effects variables and Diet and Chick
#   as random effects, where Chick is nested in Diet using lme4
chick_nested_diet <- get_nested_categories(ChickWeight$Diet, ChickWeight$Chick)
fixed_effects_matrix <- model.matrix(weight ~ as.factor(Time), data = ChickWeight)
mod_gpb <- fitGPModel(X = fixed_effects_matrix, 
                      group_data = cbind(diet=ChickWeight$Diet, chick_nested_diet), 
                      y = ChickWeight$weight)
summary(mod_gpb)
# This does (almost) the same thing as the following code using lme4:
# mod_lme4 <-  lmer(weight ~ as.factor(Time) + (1 | Diet/Chick), data = ChickWeight, REML = FALSE)
# summary(mod_lme4)
}
}
\author{
Fabio Sigrist
}
