% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{spatialGridRmult}
\alias{spatialGridRmult}
\title{Construct a regionalized multivariate data}
\usage{
spatialGridRmult(coords, data, dimcomp = 2, dimsim = NA)
}
\arguments{
\item{coords}{coordinates of the locations}

\item{data}{(observed or predicted) rmult or matrix data set; or else array of
simulated rmult /real-valued multivariate data}

\item{dimcomp}{which of the dimensions of \code{data} does correspond to the
variables?}

\item{dimsim}{if \code{data} contains simulations, which of its dimensions does
run across the realisations? leave it as NA if \code{data} has observations or predictions.}
}
\value{
A (potentially transposed/aperm-ed) matrix of class  c("spatialGridAcomp","acomp")
with the coordinates in an extra attribute "coords".
}
\description{
Connect some coordinates to a multivariate data set (of hard data, of predictions
or of simulations); currently, the coordinates
are stored in an attribute and the dataset is given a complex S3 class.
This functionality \strong{will} change in the future, to make use of package
"sp" classes.
}
\seealso{
\code{\link[=image_cokriged.spatialGridRmult]{image_cokriged.spatialGridRmult()}} for an example; \code{\link[=gsi.gstatCokriging2rmult]{gsi.gstatCokriging2rmult()}} to
restructure the output from \code{\link[gstat:predict.gstat]{gstat::predict.gstat()}} confortably
}
