% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{[[.gmCgram}
\alias{[[.gmCgram}
\title{Subsetting of gmCgram variogram structures}
\usage{
\method{[[}{gmCgram}(x, i, ...)
}
\arguments{
\item{x}{\code{gmCgram} variogram object}

\item{i}{indices of the structures that are desired to be kept (0=nugget) or removed (see details)}

\item{...}{extra arguments for generic functionality}
}
\value{
a \code{gmCgram} variogram object with the desired structures only.
}
\description{
Extraction or combination of nested structures of a gmCgram object
}
\details{
This function can be used to: extract the nugget (i=0), extract some
structures (i=indices of the structures, possibly including 0 for the nugget),
or filter some structures out (i=negative indices of the structures to remove;
nugget will always removed in this case). If you want to extract "slots" or
"elements" of the variogram, use the $-notation. If you want to extract variables of the
variogram matrices, use the \code{[}-notation. The contrary operation (adding structures together)
is obtained by summing (+) two \code{gmCgram} objects.
}
\examples{
utils::data("variogramModels")
v1 = setCgram(type=vg.Gau, sill=diag(2), anisRanges = 3*diag(c(3,1)))
v2 = setCgram(type=vg.Exp, sill=0.3*diag(2), anisRanges = 0.5*diag(2))
vm = v1+v2
vm[[1]]
}
\seealso{
Other gmCgram functions: 
\code{\link{[.gmCgram}()},
\code{\link{as.function.gmCgram}()},
\code{\link{as.gmCgram.variogramModelList}()},
\code{\link{length.gmCgram}()},
\code{\link{ndirections}()},
\code{\link{plot.gmCgram}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmCgram functions}
