% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{dynamic}
\alias{dynamic}
\title{Dynamic}
\usage{
dynamic(
  condition,
  strategy_before,
  strategy_after,
  absorb = FALSE,
  id,
  time,
  data
)
}
\arguments{
\item{condition}{a string that specifies a logical expression, upon which is met, the strategy specified in \code{strategy_after} is followed.}

\item{strategy_before}{a function or vector of intervened values that specifies the strategy followed after \code{condition} is met. 
The vector of intervened values should be the same length as the number of rows in the data frame \code{data}.}

\item{strategy_after}{a function or vector of intervened values that specifies the strategy followed before \code{condition} is met.
The vector of intervened values should be the same length as the number of rows in the data frame \code{data}.}

\item{absorb}{a logical value indicating whether the strategy specified in \code{strategy_after} becomes absorbing (always treat with the specified strategy) upon the first time when \code{condition} is met.}

\item{id}{a string specifying the ID variable name in \code{data}.}

\item{time}{a string specifying the time variable name in \code{data}.}

\item{data}{a data frame containing the observed data.}
}
\value{
a vector containing the intervened value of the same size as the number of rows in \code{data}.
}
\description{
This function specifies a dynamic intervention on the treatment variable specified in \code{data}. 
This function follows the treatment strategy specified in \code{strategy_before} until a user-defined condition that depends on covariate values is met. Upon the condition is met, the strategy specified in \code{strategy_after} is followed.
}
\examples{
data <- gfoRmulaICE::compData
# Dynamic intervention example 1: 
# treat when L1 = 0, and not treat otherwise.
dynamic1 <- dynamic(
condition = "L1 == 0", 
strategy_before = static(0, data), 
strategy_after = static(1, data), 
absorb = FALSE, 
id = "id", 
time = "t0", 
data = data
)

# Dynamic intervention example 2: 
# never treat upon until L1 = 0, after which follows always treat.
dynamic2 <- dynamic(
condition = "L1 == 0", 
strategy_before = static(0, data), 
strategy_after = static(1, data), 
absorb = TRUE, 
id = "id", 
time = "t0", 
data = data
)

# Dynamic intervention example 3: 
# never treat upon until L1 = 0, after which follows natural course.
dynamic3 <- dynamic(
condition = "L1 == 0", 
strategy_before = static(0, data), 
strategy_after = natural_course(data, "A1"), 
absorb = FALSE, 
id = "id", 
time = "t0", 
data = data
)
}
