% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sandwich.R
\name{sandwich_from_whitened_resid}
\alias{sandwich_from_whitened_resid}
\title{GLS standard errors from whitened residuals}
\usage{
sandwich_from_whitened_resid(
  Xw,
  Yw,
  beta = NULL,
  type = c("iid", "hc0"),
  df_mode = c("rankX", "n-p"),
  runs = NULL
)
}
\arguments{
\item{Xw}{Whitened design matrix.}

\item{Yw}{Whitened data matrix (time x voxels).}

\item{beta}{Optional coefficients (p x v); estimated if \code{NULL}.}

\item{type}{Either "iid" (default) or "hc0" for a robust sandwich.}

\item{df_mode}{Degrees-of-freedom mode: "rankX" (default) or "n-p".}

\item{runs}{Optional run labels (reserved for future per-run scaling).}
}
\value{
List containing standard errors, innovation variances, and XtX inverse.
}
\description{
GLS standard errors from whitened residuals
}
\examples{
# Generate example whitened data
n_time <- 200
n_pred <- 3
n_voxels <- 50
Xw <- matrix(rnorm(n_time * n_pred), n_time, n_pred)
Yw <- matrix(rnorm(n_time * n_voxels), n_time, n_voxels)

# Compute standard errors
se_result <- sandwich_from_whitened_resid(Xw, Yw, type = "iid")

# Extract standard errors for first voxel
se_voxel1 <- se_result$se[, 1]
}
