% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_children_concepts.R
\name{get_children_concepts}
\alias{get_children_concepts}
\title{Get children concepts for a specific concept from the Finto Skosmos API}
\usage{
get_children_concepts(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept whose children concepts to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing the children concepts (prefLabel, uri, hasChildren) for the specified concept.
}
\description{
Get children concepts for a specific concept from the Finto Skosmos API
}
\examples{
children <- get_children_concepts(vocid = "yso",
uri = "http://www.yso.fi/onto/yso/p690", lang = "fi")
print(children)
}
