% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-epoch.R
\name{epoch_pupil}
\alias{epoch_pupil}
\title{Main epoching and baselining logic}
\usage{
epoch_pupil(
  x,
  prev_op,
  evs,
  lims,
  label,
  c_bline,
  a_bline,
  bline_type = c("sub", "div"),
  bline_evs,
  bline_per,
  hz,
  verbose
)
}
\arguments{
\item{x}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}}

\item{prev_op}{The name of the previous operation's output column}

\item{evs}{Events specification for epoching (character vector or list)}

\item{lims}{Time limits for epochs (numeric vector)}

\item{label}{Label for the epoch output}

\item{c_bline}{Logical indicating whether to calculate baseline}

\item{a_bline}{Logical indicating whether to apply baseline correction}

\item{bline_type}{Type of baseline correction ("sub" or "div")}

\item{bline_evs}{Events specification for baseline calculation}

\item{bline_per}{Baseline period specification}

\item{hz}{Sampling rate in Hz}

\item{verbose}{A flag to indicate whether to print detailed logging messages}
}
\value{
A list containing epoch and baseline results
}
\description{
This function handles the core epoching and baselining operations for pupil
data. It processes time series data to extract epochs based on specified
events and optionally computes and applies baseline corrections.
}
\details{
This function is called by the exposed wrapper \code{\link[=epoch]{epoch()}}.
}
\keyword{internal}
