% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwcwg-distribution.R
\name{Kw-CWG}
\alias{Kw-CWG}
\alias{dkwcwg}
\alias{kwcwg}
\alias{pkwcwg}
\alias{qkwcwg}
\alias{rkwcwg}
\title{Kumaraswamy Complementary Weibull Geometric Probability Distribution}
\usage{
dkwcwg(x, alpha, beta, gamma, a, b, log = FALSE)

pkwcwg(q, alpha, beta, gamma, a, b, lower.tail = TRUE, log.p = FALSE)

qkwcwg(p, alpha, beta, gamma, a, b, lower.tail = TRUE, log.p = FALSE)

rkwcwg(n, alpha, beta, gamma, a, b)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha, beta, gamma, a, b}{Parameters of the distribution. 0 < alpha < 1, and the other parameters mustb e positive.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Kumaraswamy Complementary Weibull Geometric (Kw-CWG) probability
distribution.
}
\details{
Probability density function
\deqn{
   f(x) = \alpha^a \beta \gamma a b (\gamma x)^{\beta - 1} \exp[-(\gamma x)^\beta] \cdot
   \frac{\{1 - \exp[-(\gamma x)^\beta]\}^{a-1}}{\{ \alpha + (1 - \alpha) \exp[-(\gamma x)^\beta] \}^{a+1}} \cdot
}
\deqn{
   \cdot \bigg\{ 1 - \frac{\alpha^a[1 - \exp[-(\gamma x)^\beta]]^a}{\{ \alpha + (1 - \alpha) \exp[-(\gamma x)^\beta] \}^a} \bigg\}
}

Cumulative density function
\deqn{
    F(x) = 1 - \bigg\{  1 - \bigg[ \frac{\alpha (1 - \exp[-(\gamma x)^\beta]) }{ \alpha + (1 - \alpha) \exp[-(\gamma x)^\beta] } \bigg]^a \bigg\}^b
}

Quantile function
\deqn{
   Q(u) = \gamma^{-1} \bigg\{
       \log\bigg[\frac{
           \alpha + (1 - \alpha) \sqrt[a]{1 - \sqrt[b]{1 - u} }
       }{
           \alpha (1 - \sqrt[a]{1 - \sqrt[b]{1 - u} } )
       }\bigg]
   \bigg\}^{1/\beta}, 0 < u < 1
}
}
\references{
Afify, A.Z., Cordeiro, G.M., Butt, N.S., Ortega, E.M. and
Suzuki, A.K. (2017). A new lifetime model with variable shapes for
the hazard rate. Brazilian Journal of Probability and Statistics
}
\concept{Continuous}
\concept{Lifetime}
\concept{Univariate}
\keyword{distribution}
\keyword{models}
\keyword{survival}
\keyword{univar}
