% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_gg.R
\name{gghist}
\alias{gghist}
\title{Histogram wrapper for continuous covariates}
\usage{
gghist(d, cols, bins = 30, nsub = TRUE, ...)
}
\arguments{
\item{d}{\verb{<dfr>} A data frame.}

\item{cols}{\verb{<var>} Optional. Columns to plot as a vector of unquoted names.}

\item{bins}{\verb{<int>} Number of bins.}

\item{nsub}{\verb{<lgl>} Show number of observations.}

\item{...}{Additional arguments for \link[ggplot2:geom_histogram]{ggplot2::geom_histogram}.}
}
\value{
A ggplot object.
}
\description{
Create histograms for all numeric variables in a dataset.
Non-numeric variables will be dropped.
}
\examples{
iris |> gghist()
iris |> gghist(c(Sepal.Width,Sepal.Length))
}
