% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{createBibtex}
\alias{createBibtex}
\title{Create BibTeX format citation for software}
\usage{
createBibtex(
  key,
  title,
  authors,
  year,
  url = NULL,
  version = NULL,
  filename = NULL,
  overwrite = TRUE
)
}
\arguments{
\item{key}{BibTeX key for the entry}

\item{title}{Software title}

\item{authors}{Character vector of author names}

\item{year}{Publication year}

\item{url}{Software URL (optional)}

\item{version}{Software version (optional)}

\item{filename}{Output file path. If NULL, returns the BibTeX string without writing to file}

\item{overwrite}{Allow overwriting existing files (default: TRUE)}
}
\value{
Character string with BibTeX formatted citation, or writes to file if filename provided
}
\description{
Creates a properly formatted BibTeX citation entry for software packages.
}
\examples{
createBibtex(
  key = "ggplot2_2016",
  title = "ggplot2: Create Elegant Data Visualisations",
  authors = c("Wickham, Hadley"),
  year = "2016",
  url = "https://ggplot2.tidyverse.org",
  filename = tempfile() # Omit filename
)

# Write to file
createBibtex(
  key = "ggplot2_2016",
  title = "ggplot2: Create Elegant Data Visualisations",
  authors = c("Wickham, Hadley"),
  year = "2016",
  filename = tempfile() # Replace with e.g. "ggplot2.bib"
)
}
