% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{add_panel}
\alias{add_panel}
\alias{remove_panel}
\alias{set_panel_title}
\alias{select_panel}
\alias{move_panel}
\alias{move_group}
\alias{move_group2}
\title{Dockview Panel Operations}
\usage{
add_panel(dock, panel, ...)

remove_panel(dock, id)

set_panel_title(dock, id, title)

select_panel(dock, id)

move_panel(dock, id, position = NULL, group = NULL, index = NULL)

move_group(dock, from, to, position = NULL)

move_group2(dock, from, to, position = NULL)
}
\arguments{
\item{dock}{Dock proxy object created with \code{\link[=dock_view_proxy]{dock_view_proxy()}}.}

\item{panel}{A panel object (for \code{add_panel}). See \link{panel} for parameters.}

\item{...}{Additional options (currently unused).}

\item{id}{Panel ID (character string).}

\item{title}{New panel title.}

\item{position}{Panel/group position: one of "left", "right", "top", "bottom", "center".}

\item{group}{ID of a panel that belongs to the target group (for \code{move_panel}).}

\item{index}{Panel index within a group (for \code{move_panel}).}

\item{from}{Source group/panel ID (for move operations).}

\item{to}{Destination group/panel ID (for move operations).}
}
\value{
All functions return the dock proxy object invisibly, allowing for method chaining.
}
\description{
Functions to dynamically manipulate panels in a dockview instance.
}
\details{
\itemize{
\item \code{set_panel_title()}: Sets the title of a panel dynamically.
\item \code{add_panel()}: Adds a new panel to the dockview
\item \code{remove_panel()}: Removes an existing panel
\item \code{select_panel()}: Selects/focuses a specific panel
\item \code{move_panel()}: Moves a panel to a new position
\item \code{move_group()}: Moves a group using group IDs
\item \code{move_group2()}: Moves a group using panel IDs
}
}
\seealso{
\code{\link[=panel]{panel()}}
}
