% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-class-model-specification.R
\name{dcm_specify}
\alias{dcm_specify}
\title{Specify a diagnostic classification model}
\usage{
dcm_specify(
  qmatrix,
  identifier = NULL,
  measurement_model = lcdm(),
  structural_model = unconstrained(),
  priors = NULL
)
}
\arguments{
\item{qmatrix}{The Q-matrix. A data frame with 1 row per item and 1 column
per attribute. May optionally include an additional column of item
identifiers. If an identifier column is included, this should be specified
with \code{identifier}. All cells for the remaining attribute columns should be
either 0 (item does not measure the attribute) or 1 (item does measure the
attribute).}

\item{identifier}{Optional. If present, the quoted name of the column in the
\code{qmatrix} that contains item identifiers.}

\item{measurement_model}{A \link[=measurement-model]{measurement model} object.}

\item{structural_model}{A \link[=structural-model]{structural model} object.}

\item{priors}{A prior object created by \code{\link[=prior]{prior()}}. If \code{NULL} (the default),
default prior distributions defined by \code{\link[=default_dcm_priors]{default_dcm_priors()}} are used.}
}
\value{
A \code{dcm_specification} object.
}
\description{
Create the specifications for a Bayesian diagnostic classification model.
Choose the measurement and structural models that match your assumptions of
your data. Then choose your prior distributions, or use the defaults. The
model specification can then be used to generate the 'Stan' code needed to
estimate the model.
}
\examples{
qmatrix <- data.frame(
  att1 = sample(0:1, size = 15, replace = TRUE),
  att2 = sample(0:1, size = 15, replace = TRUE),
  att3 = sample(0:1, size = 15, replace = TRUE),
  att4 = sample(0:1, size = 15, replace = TRUE)
)

dcm_specify(qmatrix = qmatrix,
            measurement_model = lcdm(),
            structural_model = unconstrained())
}
\seealso{
\link{measurement-model}, \link{structural-model}.
}
