% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skcla_nb.R
\name{skcla_nb}
\alias{skcla_nb}
\title{Gaussian Naive Bayes Classifier}
\usage{
skcla_nb(attribute, slevels, var_smoothing = 1e-09, priors = NULL)
}
\arguments{
\item{attribute}{Target attribute name for model building}

\item{slevels}{List of possible values for classification target}

\item{var_smoothing}{Portion of the largest variance of all features that is added to variances}

\item{priors}{Prior probabilities of the classes. If specified must be a list of length n_classes}
}
\value{
A \code{skcla_nb} classifier object.
}
\description{
Implements classification using Gaussian Naive Bayes.
Wraps scikit-learn's \code{GaussianNB} through \code{reticulate}.
}
\details{
Naive Bayes Classifier
}
\examples{
\dontrun{
data(iris)

# Gaussian Naive Bayes for multi-class iris
clf <- skcla_nb(attribute = 'Species', slevels = levels(iris$Species))
clf <- daltoolbox::fit(clf, iris)
pred <- predict(clf, iris)
table(pred, iris$Species)
}

# More examples:
# https://github.com/cefet-rj-dal/daltoolboxdp/blob/main/examples/skcla_nb.md
}
\references{
Murphy, K. P. (2012). Machine Learning: A Probabilistic Perspective. (Gaussian Naive Bayes)
}
