% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_ig.R
\name{fs_ig}
\alias{fs_ig}
\title{Information Gain}
\usage{
fs_ig(attribute)
}
\arguments{
\item{attribute}{Character. Name of the target variable.}
}
\value{
A \code{fs_ig} object.
}
\description{
Information Gain (IG) is an information-theoretic feature selection technique
that measures reduction in entropy of the target when a feature is observed. Wraps the
\code{FSelector} package.
}
\examples{
\dontrun{
data(iris)

# 1) Ensure target is a factor for IG-based ranking
iris2 <- iris
iris2$Species <- as.factor(iris2$Species)

# 2) Fit selector and inspect chosen features
fs <- daltoolbox::fit(fs_ig("Species"), iris2)
fs$features                     # names of selected predictors

# 3) Subset data to selected features + target
data_ig <- daltoolbox::transform(fs, iris2)
head(data_ig)
}
}
\references{
Quinlan, J. R. (1986). Induction of Decision Trees.
}
