library(cvms)
context("choosing metrics")

test_that("gaussian_metrics()", {


  # Load data and fold it
  xpectr::set_test_seed(1)

  get_metric_names <- function(...){
    set_metrics("gaussian", metrics_list = gaussian_metrics(...),
                include_model_object_metrics = TRUE)
  }

  # xpectr::gxs_function(fn = get_metric_names,
  #                      args_values = list(
  #                        all = list(NULL,FALSE, TRUE, NA, 1, 0, "hej", list(FALSE)),
  #                        rmse = list(FALSE, TRUE, NA),
  #                        male = list(FALSE, TRUE, NA)
  #                      ), indentation = 2)


  ## Testing 'get_metric_names'                                               ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing get_metric_names(all = NULL, rmse = FALSE, m...
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- get_metric_names(all = NULL, rmse = FALSE, male = FALSE)
  # Testing class
  expect_equal(
    class(output_12655),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "character")
  # Testing values
  expect_equal(
    output_12655,
    c("MAE", "NRMSE(IQR)", "RRSE", "RAE", "RMSLE"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    5L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    5L)

  # Testing get_metric_names(all = FALSE, rmse = FALSE, ...
  # Changed from baseline: all = FALSE
  xpectr::set_test_seed(42)
  # Assigning output
  output_13721 <- get_metric_names(all = FALSE, rmse = FALSE, male = FALSE)
  # Testing class
  expect_equal(
    class(output_13721),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_13721,
    type = "character")
  # Testing values
  expect_equal(
    output_13721,
    character(0),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_13721),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_13721),
    0L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_13721)),
    0L)

  # Testing get_metric_names(all = TRUE, rmse = FALSE, m...
  # Changed from baseline: all = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_15728 <- get_metric_names(all = TRUE, rmse = FALSE, male = FALSE)
  # Testing class
  expect_equal(
    class(output_15728),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15728,
    type = "character")
  # Testing values
  expect_equal(
    output_15728,
    c("MAE", "NRMSE(RNG)", "NRMSE(IQR)", "NRMSE(STD)", "NRMSE(AVG)",
      "RSE", "RRSE", "RAE", "RMSLE", "MAPE", "MSE", "TAE", "TSE",
      "r2m", "r2c", "AIC", "AICc", "BIC"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_15728),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15728),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15728)),
    18L)

  # Testing get_metric_names(all = NA, rmse = FALSE, mal...
  # Changed from baseline: all = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19082 <- xpectr::capture_side_effects(get_metric_names(all = NA, rmse = FALSE, male = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19082[['error']]),
    xpectr::strip("Assertion on 'all' failed: May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19082[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing get_metric_names(all = 1, rmse = FALSE, male...
  # Changed from baseline: all = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12016 <- xpectr::capture_side_effects(get_metric_names(all = 1, rmse = FALSE, male = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12016[['error']]),
    xpectr::strip("Assertion on 'all' failed: Must be of type 'logical flag' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12016[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing get_metric_names(all = 0, rmse = FALSE, male...
  # Changed from baseline: all = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18983 <- xpectr::capture_side_effects(get_metric_names(all = 0, rmse = FALSE, male = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18983[['error']]),
    xpectr::strip("Assertion on 'all' failed: Must be of type 'logical flag' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18983[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing get_metric_names(all = "hej", rmse = FALSE, ...
  # Changed from baseline: all = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19446 <- xpectr::capture_side_effects(get_metric_names(all = "hej", rmse = FALSE, male = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19446[['error']]),
    xpectr::strip("Assertion on 'all' failed: Must be of type 'logical flag' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19446[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing get_metric_names(all = list(FALSE), rmse = F...
  # Changed from baseline: all = list(FALSE)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16607 <- xpectr::capture_side_effects(get_metric_names(all = list(FALSE), rmse = FALSE, male = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16607[['error']]),
    xpectr::strip("Assertion on 'all' failed: Must be of type 'logical flag' (or 'NULL'), not 'list'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16607[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing get_metric_names(all = NULL, rmse = TRUE, ma...
  # Changed from baseline: rmse = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_16291 <- get_metric_names(all = NULL, rmse = TRUE, male = FALSE)
  # Testing class
  expect_equal(
    class(output_16291),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16291,
    type = "character")
  # Testing values
  expect_equal(
    output_16291,
    c("RMSE", "MAE", "NRMSE(IQR)", "RRSE", "RAE", "RMSLE"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_16291),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16291),
    6L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16291)),
    6L)

  # Testing get_metric_names(all = NULL, rmse = NA, male...
  # Changed from baseline: rmse = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10617 <- xpectr::capture_side_effects(get_metric_names(all = NULL, rmse = NA, male = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10617[['error']]),
    xpectr::strip("Assertion on 'rmse' failed: May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10617[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing get_metric_names(all = NULL, rmse = NULL, ma...
  # Changed from baseline: rmse = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_12059 <- get_metric_names(all = NULL, rmse = NULL, male = FALSE)
  # Testing class
  expect_equal(
    class(output_12059),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12059,
    type = "character")
  # Testing values
  expect_equal(
    output_12059,
    c("RMSE", "MAE", "NRMSE(IQR)", "RRSE", "RAE", "RMSLE"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_12059),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12059),
    6L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12059)),
    6L)

  # Testing get_metric_names(all = NULL, rmse = FALSE, m...
  # Changed from baseline: male = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_11765 <- get_metric_names(all = NULL, rmse = FALSE, male = TRUE)
  # Testing class
  expect_equal(
    class(output_11765),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11765,
    type = "character")
  # Testing values
  expect_equal(
    output_11765,
    c("MAE", "NRMSE(IQR)", "RRSE", "RAE", "RMSLE", "MALE"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_11765),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11765),
    6L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11765)),
    6L)

  # Testing get_metric_names(all = NULL, rmse = FALSE, m...
  # Changed from baseline: male = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16870 <- xpectr::capture_side_effects(get_metric_names(all = NULL, rmse = FALSE, male = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16870[['error']]),
    xpectr::strip("Assertion on 'male' failed: May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16870[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing get_metric_names(all = NULL, rmse = FALSE, m...
  # Changed from baseline: male = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_13841 <- get_metric_names(all = NULL, rmse = FALSE, male = NULL)
  # Testing class
  expect_equal(
    class(output_13841),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_13841,
    type = "character")
  # Testing values
  expect_equal(
    output_13841,
    c("MAE", "NRMSE(IQR)", "RRSE", "RAE", "RMSLE"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_13841),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_13841),
    5L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_13841)),
    5L)

  ## Finished testing 'get_metric_names'                                      ####
  #


  # Manual testing:

  ## Testing 'get_metric_names(all = TRUE)'                                 ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- get_metric_names(all = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "character")
  # Testing values
  expect_equal(
    output_19148,
    c("RMSE", "MAE", "NRMSE(RNG)", "NRMSE(IQR)", "NRMSE(STD)", "NRMSE(AVG)",
      "RSE", "RRSE", "RAE", "RMSLE", "MALE", "MAPE", "MSE", "TAE",
      "TSE", "r2m", "r2c", "AIC", "AICc", "BIC"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    20L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    20L)
  ## Finished testing 'get_metric_names(all = TRUE)'                        ####


})

test_that("binomial_metrics()", {

  # Load data and fold it
  xpectr::set_test_seed(1)

  get_metric_names <- function(...){
    set_metrics("binomial", metrics_list = binomial_metrics(...),
                include_model_object_metrics = TRUE)
  }

  # xpectr::gxs_function(fn = get_metric_names,
  #                      args_values = list(
  #                        all = list(NULL,FALSE, TRUE, NA, 1, 0, "hej", list(FALSE)),
  #                        accuracy = list(FALSE, TRUE, NA),
  #                        f1 = list(FALSE, TRUE, NA)
  #                      ), indentation = 2)

  ## Testing 'get_metric_names'                                               ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing get_metric_names(all = FALSE, accuracy = FALSE...
  # Assigning output
  output_12654 <- get_metric_names(all = FALSE, accuracy = FALSE, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_12654),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12654,
    type = "character")
  # Testing values
  expect_equal(
    output_12654,
    character(0),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_12654),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12654),
    0L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12654)),
    0L)

  # Testing get_metric_names(all = NULL, accuracy = FALSE,...
  # Assigning output
  output_13720 <- get_metric_names(all = NULL, accuracy = FALSE, f1 = TRUE)
  # Testing class
  expect_equal(
    class(output_13720),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_13720,
    type = "character")
  # Testing values
  expect_equal(
    output_13720,
    c("Balanced Accuracy", "F1", "Sensitivity", "Specificity", "Pos Pred Value",
      "Neg Pred Value", "AUC", "Lower CI", "Upper CI", "Kappa",
      "MCC", "Detection Rate", "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_13720),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_13720),
    14L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_13720)),
    14L)

  # Testing get_metric_names(all = NULL, accuracy = FALSE,...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = NULL, accuracy = FALSE, f1 = NA)),
    xpectr::strip("Assertion on 'f1' failed: May not be NA."),
    fixed = TRUE)

  # Testing get_metric_names(all = TRUE, accuracy = FALSE,...
  # Assigning output
  output_15727 <- get_metric_names(all = TRUE, accuracy = FALSE, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_15727),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15727,
    type = "character")
  # Testing values
  expect_equal(
    output_15727,
    c("Balanced Accuracy", "Sensitivity", "Specificity", "Pos Pred Value",
      "Neg Pred Value", "AUC", "Lower CI", "Upper CI", "Kappa",
      "MCC", "Detection Rate", "Detection Prevalence", "Prevalence",
      "False Neg Rate", "False Pos Rate", "False Discovery Rate",
      "False Omission Rate", "Threat Score", "AIC", "AICc", "BIC"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_15727),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15727),
    21L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15727)),
    21L)

  # Testing get_metric_names(all = NA, accuracy = FALSE, f...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = NA, accuracy = FALSE, f1 = FALSE)),
    xpectr::strip("Assertion on 'all' failed: May not be NA."),
    fixed = TRUE)

  # Testing get_metric_names(all = 1, accuracy = FALSE, f1...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = 1, accuracy = FALSE, f1 = FALSE)),
    xpectr::strip(paste0("Assertion on 'all' failed: Must be of type 'logical flag' (o",
           "r 'NULL'), not 'double'.")),
    fixed = TRUE)

  # Testing get_metric_names(all = 0, accuracy = FALSE, f1...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = 0, accuracy = FALSE, f1 = FALSE)),
    xpectr::strip(paste0("Assertion on 'all' failed: Must be of type 'logical flag' (o",
           "r 'NULL'), not 'double'.")),
    fixed = TRUE)

  # Testing get_metric_names(all = "hej", accuracy = FALSE...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = "hej", accuracy = FALSE, f1 = FALSE)),
    xpectr::strip(paste0("Assertion on 'all' failed: Must be of type 'logical flag' (o",
           "r 'NULL'), not 'character'.")),
    fixed = TRUE)

  # Testing get_metric_names(all = list(FALSE), accuracy =...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = list(FALSE), accuracy = FALSE, f1 = FALSE)),
    xpectr::strip(paste0("Assertion on 'all' failed: Must be of type 'logical flag' (o",
           "r 'NULL'), not 'list'.")),
    fixed = TRUE)

  # Testing get_metric_names(all = NULL, accuracy = TRUE, ...
  # Assigning output
  output_19081 <- get_metric_names(all = NULL, accuracy = TRUE, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_19081),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19081,
    type = "character")
  # Testing values
  expect_equal(
    output_19081,
    c("Balanced Accuracy", "Accuracy", "Sensitivity", "Specificity",
      "Pos Pred Value", "Neg Pred Value", "AUC", "Lower CI", "Upper CI",
      "Kappa", "MCC", "Detection Rate", "Detection Prevalence",
      "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19081),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19081),
    14L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19081)),
    14L)

  # Testing get_metric_names(all = NULL, accuracy = NA, f1...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = NULL, accuracy = NA, f1 = FALSE)),
    xpectr::strip("Assertion on 'accuracy' failed: May not be NA."),
    fixed = TRUE)

  # Testing get_metric_names(all = NULL, accuracy = NULL, ...
  # Assigning output
  output_12016 <- get_metric_names(all = NULL, accuracy = NULL, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_12016),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12016,
    type = "character")
  # Testing values
  expect_equal(
    output_12016,
    c("Balanced Accuracy", "Sensitivity", "Specificity", "Pos Pred Value",
      "Neg Pred Value", "AUC", "Lower CI", "Upper CI", "Kappa",
      "MCC", "Detection Rate", "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_12016),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12016),
    13L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12016)),
    13L)

  # Testing get_metric_names(all = NULL, accuracy = FALSE,...
  # Assigning output
  output_18982 <- get_metric_names(all = NULL, accuracy = FALSE, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_18982),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18982,
    type = "character")
  # Testing values
  expect_equal(
    output_18982,
    c("Balanced Accuracy", "Sensitivity", "Specificity", "Pos Pred Value",
      "Neg Pred Value", "AUC", "Lower CI", "Upper CI", "Kappa",
      "MCC", "Detection Rate", "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_18982),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18982),
    13L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18982)),
    13L)

  # Testing get_metric_names(all = NULL, accuracy = FALSE,...
  # Assigning output
  output_19445 <- get_metric_names(all = NULL, accuracy = FALSE, f1 = NULL)
  # Testing class
  expect_equal(
    class(output_19445),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19445,
    type = "character")
  # Testing values
  expect_equal(
    output_19445,
    c("Balanced Accuracy", "F1", "Sensitivity", "Specificity", "Pos Pred Value",
      "Neg Pred Value", "AUC", "Lower CI", "Upper CI", "Kappa",
      "MCC", "Detection Rate", "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19445),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19445),
    14L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19445)),
    14L)

  ## Finished testing 'get_metric_names'                                      ####


  ## Testing 'get_metric_names(all = TRUE)'                                 ####
  ## Initially generated by xpectr
  # Assigning output
  output_16607 <- get_metric_names(all = TRUE)
  # Testing class
  expect_equal(
    class(output_16607),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16607,
    type = "character")
  # Testing values
  expect_equal(
    output_16607,
    c("Balanced Accuracy", "Accuracy", "F1", "Sensitivity", "Specificity",
      "Pos Pred Value", "Neg Pred Value", "AUC", "Lower CI", "Upper CI",
      "Kappa", "MCC", "Detection Rate", "Detection Prevalence",
      "Prevalence", "False Neg Rate", "False Pos Rate", "False Discovery Rate",
      "False Omission Rate", "Threat Score", "AIC", "AICc", "BIC"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_16607),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16607),
    23L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16607)),
    23L)
  ## Finished testing 'get_metric_names(all = TRUE)'                        ####

})

test_that("multinomial_metrics()", {

  # Load data and fold it
  xpectr::set_test_seed(1)

  get_metric_names <- function(...){
    set_metrics("multinomial", metrics_list = multinomial_metrics(...),
                include_model_object_metrics = TRUE)
  }

  # xpectr::gxs_function(fn = get_metric_names,
  #                      args_values = list(
  #                        all = list(NULL,FALSE, TRUE, NA, 1, 0, "hej", list(FALSE)),
  #                        accuracy = list(FALSE, TRUE, NA),
  #                        f1 = list(FALSE, TRUE, NA)
  #                      ), indentation = 2)

  ## Testing 'get_metric_names'                                               ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing get_metric_names(all = FALSE, accuracy = FALSE...
  # Assigning output
  output_17375 <- get_metric_names(all = FALSE, accuracy = FALSE, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_17375),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17375,
    type = "character")
  # Testing values
  expect_equal(
    output_17375,
    character(0),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_17375),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17375),
    0L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17375)),
    0L)

  # Testing get_metric_names(all = NULL, accuracy = FALSE,...
  # Assigning output
  output_18109 <- get_metric_names(all = NULL, accuracy = FALSE, f1 = TRUE)
  # Testing class
  expect_equal(
    class(output_18109),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18109,
    type = "character")
  # Testing values
  expect_equal(
    output_18109,
    c("Overall Accuracy", "Balanced Accuracy", "F1", "Sensitivity",
      "Specificity", "Pos Pred Value", "Neg Pred Value", "Kappa",
      "MCC", "Detection Rate", "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_18109),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18109),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18109)),
    12L)

  # Testing get_metric_names(all = NULL, accuracy = FALSE,...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = NULL, accuracy = FALSE, f1 = NA)),
    xpectr::strip("Assertion on 'f1' failed: May not be NA."),
    fixed = TRUE)

  # Testing get_metric_names(all = TRUE, accuracy = FALSE,...
  # Assigning output
  output_13880 <- get_metric_names(all = TRUE, accuracy = FALSE, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_13880),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_13880,
    type = "character")
  # Testing values
  expect_equal(
    xpectr::smpl(output_13880, n = 30),
    c("Overall Accuracy", "Weighted Balanced Accuracy", "Weighted Accuracy",
    "Sensitivity", "Weighted Specificity", "Pos Pred Value", "Weighted Pos Pred Value",
    "Neg Pred Value", "Weighted Neg Pred Value", "AUC", "Kappa",
    "MCC", "Detection Rate", "Weighted Detection Rate", "Detection Prevalence",
    "Weighted Detection Prevalence", "Prevalence", "Weighted Prevalence",
    "False Neg Rate", "Weighted False Neg Rate", "Weighted False Pos Rate",
    "False Discovery Rate", "Weighted False Discovery Rate", "False Omission Rate",
    "Weighted False Omission Rate", "Threat Score", "Weighted Threat Score",
    "AIC", "AICc", "BIC"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(xpectr::smpl(output_13880, n = 30)),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_13880),
    36L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_13880)),
    36L)

  # Testing get_metric_names(all = NA, accuracy = FALSE, f...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = NA, accuracy = FALSE, f1 = FALSE)),
    xpectr::strip("Assertion on 'all' failed: May not be NA."),
    fixed = TRUE)

  # Testing get_metric_names(all = 1, accuracy = FALSE, f1...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = 1, accuracy = FALSE, f1 = FALSE)),
    xpectr::strip(paste0("Assertion on 'all' failed: Must be of type 'logical flag' (o",
           "r 'NULL'), not 'double'.")),
    fixed = TRUE)

  # Testing get_metric_names(all = 0, accuracy = FALSE, f1...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = 0, accuracy = FALSE, f1 = FALSE)),
    xpectr::strip(paste0("Assertion on 'all' failed: Must be of type 'logical flag' (o",
           "r 'NULL'), not 'double'.")),
    fixed = TRUE)

  # Testing get_metric_names(all = "hej", accuracy = FALSE...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = "hej", accuracy = FALSE, f1 = FALSE)),
    xpectr::strip(paste0("Assertion on 'all' failed: Must be of type 'logical flag' (o",
           "r 'NULL'), not 'character'.")),
    fixed = TRUE)

  # Testing get_metric_names(all = list(FALSE), accuracy =...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = list(FALSE), accuracy = FALSE, f1 = FALSE)),
    xpectr::strip(paste0("Assertion on 'all' failed: Must be of type 'logical flag' (o",
           "r 'NULL'), not 'list'.")),
    fixed = TRUE)

  # Testing get_metric_names(all = NULL, accuracy = TRUE, ...
  # Assigning output
  output_17375 <- get_metric_names(all = NULL, accuracy = TRUE, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_17375),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17375,
    type = "character")
  # Testing values
  expect_equal(
    output_17375,
    c("Overall Accuracy", "Balanced Accuracy", "Accuracy", "Sensitivity",
      "Specificity", "Pos Pred Value", "Neg Pred Value", "Kappa",
      "MCC", "Detection Rate", "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_17375),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17375),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17375)),
    12L)

  # Testing get_metric_names(all = NULL, accuracy = NA, f1...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(get_metric_names(all = NULL, accuracy = NA, f1 = FALSE)),
    xpectr::strip("Assertion on 'accuracy' failed: May not be NA."),
    fixed = TRUE)

  # Testing get_metric_names(all = NULL, accuracy = NULL, ...
  # Assigning output
  output_18109 <- get_metric_names(all = NULL, accuracy = NULL, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_18109),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18109,
    type = "character")
  # Testing values
  expect_equal(
    output_18109,
    c("Overall Accuracy", "Balanced Accuracy", "Sensitivity", "Specificity",
      "Pos Pred Value", "Neg Pred Value", "Kappa", "MCC", "Detection Rate",
      "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_18109),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18109),
    11L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18109)),
    11L)

  # Testing get_metric_names(all = NULL, accuracy = FALSE,...
  # Assigning output
  output_13880 <- get_metric_names(all = NULL, accuracy = FALSE, f1 = FALSE)
  # Testing class
  expect_equal(
    class(output_13880),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_13880,
    type = "character")
  # Testing values
  expect_equal(
    output_13880,
    c("Overall Accuracy", "Balanced Accuracy", "Sensitivity", "Specificity",
      "Pos Pred Value", "Neg Pred Value", "Kappa", "MCC", "Detection Rate",
      "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_13880),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_13880),
    11L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_13880)),
    11L)

  # Testing get_metric_names(all = NULL, accuracy = FALSE,...
  # Assigning output
  output_16851 <- get_metric_names(all = NULL, accuracy = FALSE, f1 = NULL)
  # Testing class
  expect_equal(
    class(output_16851),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16851,
    type = "character")
  # Testing values
  expect_equal(
    output_16851,
    c("Overall Accuracy", "Balanced Accuracy", "F1", "Sensitivity",
      "Specificity", "Pos Pred Value", "Neg Pred Value", "Kappa",
      "MCC", "Detection Rate", "Detection Prevalence", "Prevalence"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_16851),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16851),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16851)),
    12L)

  ## Finished testing 'get_metric_names'                                      ####



  ## Testing 'get_metric_names(all = TRUE)'                                 ####
  ## Initially generated by xpectr
  # Assigning output
  output_12654 <- get_metric_names(all = TRUE)
  # Testing class
  expect_equal(
    class(output_12654),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12654,
    type = "character")
  # Testing values
  expect_equal(
    xpectr::smpl(output_12654, n = 30),
    c("Balanced Accuracy", "Weighted Balanced Accuracy", "Weighted Accuracy",
    "Weighted F1", "Sensitivity", "Specificity", "Weighted Specificity",
    "Pos Pred Value", "Weighted Pos Pred Value", "Weighted Neg Pred Value",
    "AUC", "Kappa", "Weighted Kappa", "Detection Rate", "Weighted Detection Rate",
    "Detection Prevalence", "Weighted Detection Prevalence", "Prevalence",
    "Weighted Prevalence", "False Neg Rate", "Weighted False Neg Rate",
    "Weighted False Pos Rate", "False Discovery Rate", "Weighted False Discovery Rate",
    "False Omission Rate", "Threat Score", "Weighted Threat Score",
    "AIC", "AICc", "BIC"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(xpectr::smpl(output_12654, n = 30)),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12654),
    38L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12654)),
    38L)
  ## Finished testing 'get_metric_names(all = TRUE)'                        ####

})

